/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.silentgems;

import com.google.common.base.CaseFormat;
import it.hurts.metallurgy_reforged.material.MetalStats;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.stream.IntStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;

public class MetallurgyPartProperties
implements IPartProperties {
    private final MetalStats stats;
    private final Item ingot;

    public MetallurgyPartProperties(MetalStats metalStats, Item ingot) {
        this.stats = metalStats;
        this.ingot = ingot;
    }

    public MetalStats getMetalStats() {
        return this.stats;
    }

    public String getName() {
        return Utils.localizeEscapingCustomSequences("material.metallurgy." + this.stats.getName() + ".name");
    }

    public String getNamePrefix() {
        return "";
    }

    public int getColor() {
        return this.stats.getColorHex();
    }

    public EnumMaterialTier getTier() {
        int tier = (this.stats.getToolStats().getHarvestLevel() - 1) / 3;
        if (tier > 2) {
            tier = 2;
        }
        return EnumMaterialTier.values()[tier];
    }

    public int getDurability() {
        return this.stats.getToolStats().getMaxUses();
    }

    public float getMiningSpeed() {
        return this.stats.getToolStats().getEfficiency();
    }

    public int getHarvestLevel() {
        return this.stats.getToolStats().getHarvestLevel();
    }

    public float getMeleeDamage() {
        return this.stats.getToolStats().getDamage();
    }

    public float getMagicDamage() {
        return (float)this.stats.getToolStats().getToolMagic() / 6.0f;
    }

    public float getMeleeSpeed() {
        return this.stats.getToolStats().getEfficiency() / 6.0f;
    }

    public int getEnchantability() {
        return this.stats.getToolStats().getToolMagic();
    }

    public float getChargeSpeed() {
        return 3.0f;
    }

    public float getProtection() {
        if (this.stats.getArmorStats() != null) {
            return IntStream.of(this.stats.getArmorStats().getDamageReduction()).sum();
        }
        return 1.0f;
    }

    public ItemStack getCraftingStack() {
        return new ItemStack(this.ingot, 1);
    }

    public String getCraftingOreName() {
        return "ingot" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.stats.getName());
    }
}

