/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.jei.chamber;

import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.integration.jei.chamber.ChamberRecipeWrapper;
import it.hurts.metallurgy_reforged.recipe.SublimationRecipes;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ChamberRecipeCategory
implements IRecipeCategory<ChamberRecipeWrapper> {
    public static final int INPUT_SLOT = 0;
    private final IDrawableStatic background;
    private final IDrawableAnimated flame;
    private int effectIndex;

    public ChamberRecipeCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("metallurgy", "textures/gui/sublimation_chamber_jei.png");
        this.background = helper.createDrawable(texture, 4, 4, 168, 74);
        IDrawableStatic flameDrawable = helper.createDrawable(texture, 176, 0, 14, 14);
        this.flame = helper.createAnimatedDrawable(flameDrawable, 150, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 75, 49);
    }

    @Nonnull
    public String getUid() {
        return "metallurgy.sublimation_chamber";
    }

    @Nonnull
    public String getTitle() {
        return new ItemStack((Block)ModBlocks.chamber).func_82833_r();
    }

    @Nonnull
    public String getModName() {
        return "Metallurgy 4: Reforged";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ChamberRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 42, 26);
        group.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        this.effectIndex = SublimationRecipes.getInstance().recipesMap().get(recipeWrapper.getInput()).func_188419_a().func_76392_e();
    }
}

