/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.jei.alloyer;

import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.integration.jei.alloyer.AlloyerRecipeWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AlloyerRecipeCategory
implements IRecipeCategory<AlloyerRecipeWrapper> {
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int OUTPUT_SLOT = 2;
    private final IDrawableStatic background;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated bar;
    private final IDrawableAnimated moltenMetal;

    public AlloyerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation texture = new ResourceLocation("metallurgy", "textures/gui/alloyer.png");
        this.background = guiHelper.createDrawable(texture, 0, 0, 176, 108);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(texture, 176, 61, 17, 17);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic moltenDrawable = guiHelper.createDrawable(texture, 176, 81, 10, 25);
        this.moltenMetal = guiHelper.createAnimatedDrawable(moltenDrawable, 80, IDrawableAnimated.StartDirection.TOP, false);
        IDrawableStatic barDrawable = guiHelper.createDrawable(texture, 176, 0, 7, 33);
        this.bar = guiHelper.createAnimatedDrawable(barDrawable, 80, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.flame.draw(minecraft, 110, 61);
        this.bar.draw(minecraft, 40, 66);
        this.moltenMetal.draw(minecraft, 52, 32);
    }

    @Nonnull
    public String getUid() {
        return "metallurgy.alloyer";
    }

    @Nonnull
    public String getTitle() {
        return new ItemStack((Block)ModBlocks.alloyer).func_82833_r();
    }

    @Nonnull
    public String getModName() {
        return "Metallurgy 4: Reforged";
    }

    @Nonnull
    public IDrawableStatic getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull AlloyerRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 101, 23);
        group.init(1, true, 122, 23);
        group.init(2, false, 56, 73);
        group.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        group.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        group.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

