/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.jei;

import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.fluid.ModFluids;
import it.hurts.metallurgy_reforged.gui.GuiAlloyer;
import it.hurts.metallurgy_reforged.gui.GuiCrusher;
import it.hurts.metallurgy_reforged.integration.jei.OreDetectorWrapper;
import it.hurts.metallurgy_reforged.integration.jei.alloyer.AlloyerRecipeCategory;
import it.hurts.metallurgy_reforged.integration.jei.alloyer.AlloyerRecipeWrapper;
import it.hurts.metallurgy_reforged.integration.jei.chamber.ChamberRecipeCategory;
import it.hurts.metallurgy_reforged.integration.jei.chamber.ChamberRecipeWrapper;
import it.hurts.metallurgy_reforged.integration.jei.crusher.CrusherRecipeCategory;
import it.hurts.metallurgy_reforged.integration.jei.crusher.CrusherRecipeWrapper;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.ArrayList;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class IntegrationJEI
implements IModPlugin {
    public static final String CRUSHER = "metallurgy.crusher";
    public static final String ALLOYER = "metallurgy.alloyer";
    public static final String SUBLIMATION_CHAMBER = "metallurgy.sublimation_chamber";

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CrusherRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyerRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChamberRecipeCategory(guiHelper)});
    }

    public void register(IModRegistry registry) {
        registry.addRecipes(CrusherRecipeWrapper.getRecipeInputs(), CRUSHER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crusher), new String[]{CRUSHER});
        registry.addRecipeClickArea(GuiCrusher.class, 93, 32, 7, 33, new String[]{CRUSHER});
        registry.addRecipes(AlloyerRecipeWrapper.getRecipeInputs(), ALLOYER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.alloyer), new String[]{ALLOYER});
        registry.addRecipeClickArea(GuiAlloyer.class, 40, 32, 7, 33, new String[]{ALLOYER});
        registry.addRecipes(ChamberRecipeWrapper.getRecipeInputs(), SUBLIMATION_CHAMBER);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.chamber), new String[]{SUBLIMATION_CHAMBER});
        registry.addIngredientInfo((Object)new ItemStack((Block)ModBlocks.oreTar), VanillaTypes.ITEM, new String[]{"description.jei_compat.tar_processing"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.TAR), VanillaTypes.ITEM, new String[]{"description.jei_compat.tar_processing"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.BITUMEN), VanillaTypes.ITEM, new String[]{"description.jei_compat.tar_processing"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.INVISIBILITY_SHIELD), VanillaTypes.ITEM, new String[]{"description.jei_compat.invisibility_shield"});
        registry.addIngredientInfo((Object)new ItemStack((Item)ModItems.THERMITE_DUST), VanillaTypes.ITEM, new String[]{"description.jei_compat.thermite"});
        registry.addIngredientInfo((Object)ModFluids.THERMITE.getFluidStack(), VanillaTypes.FLUID, new String[]{"description.jei_compat.thermite"});
        ArrayList<ItemStack> krikArmor = new ArrayList<ItemStack>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) continue;
            krikArmor.add(new ItemStack((Item)ModMetals.KRIK.getArmorPiece(slot)));
        }
        registry.addIngredientInfo(krikArmor, VanillaTypes.ITEM, new String[]{"description.jei_compat.krik_armor"});
        ArrayList<OreDetectorWrapper> oreDetectorRecipes = new ArrayList<OreDetectorWrapper>();
        for (int i = 0; i <= 3; ++i) {
            oreDetectorRecipes.add(new OreDetectorWrapper(i));
        }
        registry.addRecipes(oreDetectorRecipes, "minecraft.crafting");
    }
}

