/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import it.hurts.metallurgy_reforged.integration.crafttweaker.IntegrationCT;
import it.hurts.metallurgy_reforged.recipe.CrusherRecipes;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.metallurgyreforged.Crusher")
public class CompatCrusher {
    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Add(input, output));
    }

    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output, float xp) {
        CraftTweakerAPI.apply((IAction)new Add(input, output, xp));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(output));
    }

    private static class Remove
    implements IAction {
        private final IItemStack output;

        Remove(IItemStack output) {
            this.output = output;
        }

        public void apply() {
            CrusherRecipes.getInstance().removeCrushingRecipe(IntegrationCT.toStack(this.output));
        }

        public String describe() {
            return "Removing Metallurgy-Reforged Crusher Recipe for " + this.output.getDisplayName();
        }
    }

    private static class Add
    implements IAction {
        private final IIngredient input;
        private final IItemStack output;
        private final float xp;

        Add(IIngredient input, IItemStack output) {
            this(input, output, 0.0f);
        }

        Add(IIngredient input, IItemStack output, float xp) {
            this.input = input;
            this.output = output;
            this.xp = xp;
        }

        public void apply() {
            ItemStack[] inputStacks = IntegrationCT.toStacks(this.input.getItemArray());
            ItemStack outputStack = IntegrationCT.toStack(this.output);
            for (ItemStack inputStack : inputStacks) {
                CrusherRecipes.getInstance().addCrushingRecipe(inputStack, outputStack, this.xp);
            }
        }

        public String describe() {
            return "Adding Metallurgy-Reforged Crusher Recipe for " + this.output.getDisplayName();
        }
    }
}

