/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration.conarm;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.traits.AbstractArmorTrait;
import it.hurts.metallurgy_reforged.integration.conarm.MetallurgyArmorTraits;
import it.hurts.metallurgy_reforged.material.Metal;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;

public class SetArmorTraits {
    public static void addArmorTrait(Metal metal, Material material) {
        switch (metal.getStats().getName()) {
            case "quicksilver": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.quickly);
                break;
            }
            case "amordrine": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.stronglyAmordrine);
                break;
            }
            case "kalendrite": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.stronglyKalendrite);
                break;
            }
            case "astral_silver": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.jumpMaster);
                break;
            }
            case "celenegil": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.resistance);
                break;
            }
            case "deep_iron": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.deeply);
                break;
            }
            case "vulcanite": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.volcano);
                break;
            }
            case "adamantine": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.foodly);
                break;
            }
            case "platinum": {
                material.addTrait((ITrait)MetallurgyArmorTraits.catEyes, ArmorMaterialType.CORE);
                break;
            }
            case "prometheum": {
                material.addTrait((ITrait)MetallurgyArmorTraits.prometheum, ArmorMaterialType.PLATES);
                break;
            }
            case "shadow_steel": {
                SetArmorTraits.addToEveryPart(material, MetallurgyArmorTraits.blindness);
                break;
            }
        }
    }

    private static void addToEveryPart(Material material, AbstractArmorTrait trait) {
        material.addTrait((ITrait)trait, ArmorMaterialType.CORE);
        material.addTrait((ITrait)trait, ArmorMaterialType.PLATES);
        material.addTrait((ITrait)trait, ArmorMaterialType.TRIM);
    }
}

