/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration;

import com.google.common.collect.Table;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.fluid.ModFluids;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.model.MetalSample;
import it.hurts.metallurgy_reforged.recipe.AlloyerRecipes;
import it.hurts.metallurgy_reforged.util.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class IntegrationThermal {
    public static final String EXPANSION_MODID = "thermalexpansion";
    public static final String FOUNDATION_MODID = "thermalfoundation";
    private static final Item FOUNDATION_MATERIAL = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermalfoundation", "material"));
    private static final NBTTagCompound SAND = new ItemStack((Block)Blocks.field_150354_m).func_77955_b(new NBTTagCompound());
    private static final NBTTagCompound SLAG = new ItemStack(FOUNDATION_MATERIAL, 1, 864).func_77955_b(new NBTTagCompound());

    public static void init() {
        IntegrationThermal.addCentrifugalSeparatorRecipes();
        IntegrationThermal.addDynamoFuels();
        IntegrationThermal.loadInductionSmelterRecipes();
        IntegrationThermal.loadPulverizerRecipes();
        IntegrationThermal.loadCrucibleRecipes();
    }

    private static void addCentrifugalSeparatorRecipes() {
        for (Table.Cell alloyRecipe : AlloyerRecipes.getInstance().getRecipeTable().cellSet()) {
            ItemStack inputStack = ((MetalSample)alloyRecipe.getValue()).getStack();
            NBTTagCompound output1 = ((MetalSample)alloyRecipe.getRowKey()).getStack().func_77955_b(new NBTTagCompound());
            NBTTagCompound output2 = ((MetalSample)alloyRecipe.getColumnKey()).getStack().func_77955_b(new NBTTagCompound());
            int ratio = Math.max(((MetalSample)alloyRecipe.getColumnKey()).getAmount(), ((MetalSample)alloyRecipe.getRowKey()).getAmount());
            int energy = ratio * 2000 + 4000;
            NBTTagCompound centrifugeRecipe = IntegrationThermal.buildRecipeCompound(energy, inputStack, output1, output2);
            FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addcentrifugerecipe", (NBTTagCompound)centrifugeRecipe);
        }
    }

    private static void addDynamoFuels() {
        NBTTagCompound thermiteMolten = new NBTTagCompound();
        thermiteMolten.func_74778_a("fluid", ModFluids.THERMITE.getName());
        thermiteMolten.func_74768_a("energy", 200000);
        FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addmagmaticfuel", (NBTTagCompound)thermiteMolten);
    }

    private static void loadInductionSmelterRecipes() {
        ModMetals.metalMap.forEach((name, metal) -> {
            ItemStack ingot = new ItemStack((Item)metal.getIngot());
            if (metal.hasArmorSet()) {
                for (ItemArmorBase itemArmorBase : metal.getArmorSet()) {
                    ItemStack armorStack = new ItemStack((Item)itemArmorBase);
                    int count = -1;
                    int chance = -1;
                    switch (EntityLiving.func_184640_d((ItemStack)armorStack)) {
                        case HEAD: {
                            count = 2;
                            chance = 15;
                            break;
                        }
                        case CHEST: {
                            count = 4;
                            chance = 25;
                            break;
                        }
                        case LEGS: {
                            count = 3;
                            chance = 20;
                            break;
                        }
                        case FEET: {
                            count = 1;
                            chance = 15;
                            break;
                        }
                    }
                    assert (count != -1);
                    ingot.func_190920_e(count);
                    NBTTagCompound armorRecycleRecipe = IntegrationThermal.buildInductionSmelterCompound(6000, armorStack, ingot, chance);
                    FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addsmelterrecipe", (NBTTagCompound)armorRecycleRecipe);
                }
            }
            if (metal.hasToolSet()) {
                ingot.func_190920_e(1);
                for (ItemArmorBase itemArmorBase : metal.getToolSet()) {
                    NBTTagCompound toolRecycleRecipe = IntegrationThermal.buildInductionSmelterCompound(6000, new ItemStack((Item)itemArmorBase), ingot, 10);
                    FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addsmelterrecipe", (NBTTagCompound)toolRecycleRecipe);
                }
            }
        });
        NBTTagCompound gauntletRecycleRecipe = IntegrationThermal.buildInductionSmelterCompound(6000, new ItemStack((Item)ModItems.GAUNTLET), new ItemStack((Item)ModMetals.RUBRACIUM.getIngot(), 2), 10);
        FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addsmelterrecipe", (NBTTagCompound)gauntletRecycleRecipe);
        NBTTagCompound lemuriteShieldRecycleRecipe = IntegrationThermal.buildInductionSmelterCompound(6000, new ItemStack((Item)ModItems.INVISIBILITY_SHIELD), new ItemStack((Item)ModMetals.LEMURITE.getIngot(), 3), 25);
        FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addsmelterrecipe", (NBTTagCompound)lemuriteShieldRecycleRecipe);
    }

    private static void loadPulverizerRecipes() {
        NBTTagCompound fertilizerRecipe = IntegrationThermal.buildRecipeCompound(4000, new ItemStack((Item)ModItems.POTASH), new ItemStack((Item)ModItems.DUST_POTASH).func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addpulverizerrecipe", (NBTTagCompound)fertilizerRecipe);
    }

    private static void loadCrucibleRecipes() {
        ModMetals.metalMap.values().forEach(metal -> {
            FluidStack molten = metal.getMolten().getFluidStack();
            molten.amount = 16;
            NBTTagCompound meltNugget = IntegrationThermal.buildRecipeCompound(500, new ItemStack((Item)metal.getNugget()), NBTUtils.writeFluidStackToNBT(molten));
            FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addcruciblerecipe", (NBTTagCompound)meltNugget);
            molten.amount = 144;
            NBTTagCompound meltIngot = IntegrationThermal.buildRecipeCompound(4000, new ItemStack((Item)metal.getIngot()), NBTUtils.writeFluidStackToNBT(molten));
            FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addcruciblerecipe", (NBTTagCompound)meltIngot);
            if (!metal.isAlloy()) {
                molten.amount = 288;
                NBTTagCompound meltOre = IntegrationThermal.buildRecipeCompound(8000, new ItemStack((Block)metal.getOre()), NBTUtils.writeFluidStackToNBT(molten));
                FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addcruciblerecipe", (NBTTagCompound)meltOre);
            }
            molten.amount = 1296;
            NBTTagCompound meltBlock = IntegrationThermal.buildRecipeCompound(36000, new ItemStack((Block)metal.getBlock(BlockTypes.BLOCK)), NBTUtils.writeFluidStackToNBT(molten));
            FMLInterModComms.sendMessage((String)EXPANSION_MODID, (String)"addcruciblerecipe", (NBTTagCompound)meltBlock);
        });
    }

    private static NBTTagCompound buildRecipeCompound(int energy, ItemStack input, NBTTagCompound ... outputs) {
        NBTTagCompound recipe = new NBTTagCompound();
        recipe.func_74768_a("energy", energy);
        recipe.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        if (outputs.length == 1) {
            recipe.func_74782_a("output", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        } else if (outputs.length > 1) {
            NBTTagList outListTag = new NBTTagList();
            for (NBTTagCompound output : outputs) {
                outListTag.func_74742_a((NBTBase)output);
            }
            recipe.func_74782_a("output", (NBTBase)outListTag);
        }
        return recipe;
    }

    private static NBTTagCompound buildInductionSmelterCompound(int energy, ItemStack mainInput, ItemStack mainOutput, int chance) {
        NBTTagCompound recipe = new NBTTagCompound();
        recipe.func_74768_a("energy", energy);
        recipe.func_74782_a("input", (NBTBase)SAND);
        recipe.func_74782_a("input2", (NBTBase)mainInput.func_77955_b(new NBTTagCompound()));
        recipe.func_74782_a("output", (NBTBase)mainOutput.func_77955_b(new NBTTagCompound()));
        recipe.func_74782_a("output2", (NBTBase)SLAG);
        recipe.func_74768_a("chance", chance);
        return recipe;
    }
}

