/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.integration;

import com.google.common.base.CaseFormat;
import it.hurts.metallurgy_reforged.block.BlockMetal;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.material.ModMetals;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class IntegrationChisel {
    public static final String MODID = "chisel";

    public static void init() {
        ModMetals.metalMap.forEach((name, metal) -> {
            String pascalName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name);
            for (BlockMetal decoBlock : metal.getBlocks()) {
                if (!ForgeRegistries.BLOCKS.containsKey(decoBlock.getRegistryName()) || decoBlock.getType() == BlockTypes.BLOCK) continue;
                IntegrationChisel.addChiselVariation(pascalName + "Decor", decoBlock);
            }
        });
        ModBlocks.miscBlocks.forEach(block -> {
            if (block instanceof BlockMetal && ((BlockMetal)((Object)block)).getType() != BlockTypes.BLOCK) {
                String group = block.getRegistryName().func_110623_a().contains("iron") ? "IronDecor" : "GoldDecor";
                IntegrationChisel.addChiselVariation(group, block);
            }
        });
    }

    private static void addChiselVariation(String chiselGroup, Block block) {
        NBTTagCompound variationTag = new NBTTagCompound();
        variationTag.func_74778_a("group", chiselGroup);
        variationTag.func_74778_a("block", String.valueOf(block.getRegistryName()));
        FMLInterModComms.sendMessage((String)MODID, (String)"add_variation", (NBTTagCompound)variationTag);
    }
}

