/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.handler;

import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.client.PacketStartStopAmbienceSound;
import it.hurts.metallurgy_reforged.tileentity.TileEntityAlloyer;
import it.hurts.metallurgy_reforged.tileentity.TileEntityChamber;
import it.hurts.metallurgy_reforged.tileentity.TileEntityCrusher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class TileEntityHandler {
    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityCrusher.class, (ResourceLocation)new ResourceLocation("metallurgy:crusher"));
        GameRegistry.registerTileEntity(TileEntityAlloyer.class, (ResourceLocation)new ResourceLocation("metallurgy:alloyer"));
        GameRegistry.registerTileEntity(TileEntityChamber.class, (ResourceLocation)new ResourceLocation("metallurgy:sublimation_chamber"));
    }

    @SubscribeEvent
    public static void cleanupRemovedTileSounds(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            BlockPos pos = event.getPos();
            PacketManager.network.sendToAllAround((IMessage)new PacketStartStopAmbienceSound(pos), new NetworkRegistry.TargetPoint(event.getWorld().field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
        }
    }

    @SubscribeEvent
    public static void rightClick(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tileEntity;
        EntityPlayer pl = event.getEntityPlayer();
        World world = event.getWorld();
        if (pl.func_70093_af() && (tileEntity = world.func_175625_s(event.getPos())) instanceof TileEntityChamber) {
            ItemStack fuelStack;
            TileEntityChamber chamber = (TileEntityChamber)tileEntity;
            ItemStack handStack = pl.func_184586_b(event.getHand());
            EnumFacing facing = event.getFace();
            if (facing == EnumFacing.UP) {
                ItemStack metalStack = chamber.func_70301_a(0);
                if (!metalStack.func_190926_b() && (handStack.func_190926_b() || handStack.func_185136_b(metalStack)) && !chamber.hasEffectStarted()) {
                    int i = handStack.func_77976_d() - handStack.func_190916_E();
                    ItemStack copyStack = metalStack.func_77979_a(i);
                    copyStack.func_190920_e(handStack.func_190916_E() + copyStack.func_190916_E());
                    pl.func_184611_a(event.getHand(), copyStack);
                    event.setCanceled(true);
                }
            } else if (facing != EnumFacing.DOWN && !(fuelStack = chamber.func_70301_a(1)).func_190926_b() && (handStack.func_190926_b() || handStack.func_185136_b(fuelStack))) {
                int i = handStack.func_77976_d() - handStack.func_190916_E();
                ItemStack copyStack = fuelStack.func_77979_a(i);
                copyStack.func_190920_e(handStack.func_190916_E() + copyStack.func_190916_E());
                pl.func_184611_a(event.getHand(), copyStack);
                event.setCanceled(true);
            }
        }
    }
}

