/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.handler;

import it.hurts.metallurgy_reforged.config.GeneralConfig;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.util.EventUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class SpawnHandler {
    private static final TextComponentString GITHUB_REPO = new TextComponentString(Utils.localizeIgnoreFormat("message.github_repo_url"));
    private static Set<Class<? extends Entity>> equipReadyMobClasses = null;

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (GeneralConfig.mobsThatCanHaveEquipment.length == 0) {
            return;
        }
        if (equipReadyMobClasses == null) {
            equipReadyMobClasses = Arrays.stream(GeneralConfig.mobsThatCanHaveEquipment).map(mobId -> {
                EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mobId));
                return entry == null ? null : entry.getEntityClass();
            }).collect(Collectors.toSet());
        }
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (entity.func_184193_aE() == null || entity.func_184214_aD() == null) {
            return;
        }
        boolean isEntityValid = equipReadyMobClasses.stream().anyMatch(equipEntityCl -> entity.getClass() == equipEntityCl);
        if (!isEntityValid) {
            return;
        }
        Metal metal = EventUtils.getRandomMetalBasedOnDifficulty(event.getWorld());
        if (metal != null) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !entity.func_184582_a(slot).func_190926_b()) continue;
                entity.func_184201_a(slot, new ItemStack((Item)metal.getArmorPiece(slot)));
            }
            if (metal.hasToolSet() && entity.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                if (Math.random() < 0.25) {
                    entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(metal.getTool(EnumTools.AXE)));
                } else {
                    entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(metal.getTool(EnumTools.SWORD)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && GeneralConfig.warning) {
            GITHUB_REPO.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, GITHUB_REPO.func_150265_g())).func_150238_a(TextFormatting.BLUE);
            event.player.func_145747_a((ITextComponent)new TextComponentString(Utils.localizeEscapingCustomSequences("message.world_join_message.1")));
            event.player.func_145747_a((ITextComponent)new TextComponentString(Utils.localizeEscapingCustomSequences("message.world_join_message.3")));
            event.player.func_145747_a((ITextComponent)GITHUB_REPO);
            event.player.func_145747_a((ITextComponent)new TextComponentString(Utils.localizeEscapingCustomSequences("message.world_join_message.4")));
        }
    }
}

