/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.handler;

import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.hurts.metallurgy_reforged.block.BlockTypes;
import it.hurts.metallurgy_reforged.block.ModBlocks;
import it.hurts.metallurgy_reforged.config.RegistrationConfig;
import it.hurts.metallurgy_reforged.item.ModItems;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OreDictHandler {
    public static final Multimap<Metal, ItemStack> ALLOYING_CACHE = HashMultimap.create();

    public static void init() {
        ModMetals.metalMap.forEach((name, metal) -> {
            String pascalMetal = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, name);
            if (RegistrationConfig.categoryItems.enableMetalDusts) {
                OreDictionary.registerOre((String)("dust" + pascalMetal), (Item)metal.getDust());
            }
            ALLOYING_CACHE.put(metal, (Object)new ItemStack((Item)metal.getIngot()));
            ALLOYING_CACHE.put(metal, (Object)new ItemStack((Item)metal.getDust()));
            OreDictionary.registerOre((String)("ingot" + pascalMetal), (Item)metal.getIngot());
            if (RegistrationConfig.categoryItems.enableMetalNuggets) {
                OreDictionary.registerOre((String)("nugget" + pascalMetal), (Item)metal.getNugget());
            }
            if (!metal.isAlloy()) {
                OreDictionary.registerOre((String)("ore" + pascalMetal), (Block)metal.getOre());
            }
            if (RegistrationConfig.categoryBlocks.enableRawMetalBlocks) {
                OreDictionary.registerOre((String)("block" + pascalMetal), (Block)metal.getBlock(BlockTypes.BLOCK));
            }
        });
        OreDictionary.registerOre((String)"slimeball", (Item)ModItems.TAR);
        OreDictionary.registerOre((String)"dustGold", (Item)ModItems.GOLD_DUST);
        OreDictionary.registerOre((String)"dustIron", (Item)ModItems.IRON_DUST);
        OreDictionary.registerOre((String)"dustBitumen", (Item)ModItems.BITUMEN);
        OreDictionary.registerOre((String)"globTar", (Item)ModItems.TAR);
        OreDictionary.registerOre((String)"dustPotash", (Item)ModItems.POTASH);
        OreDictionary.registerOre((String)"dustSulfur", (Item)ModItems.SULFUR);
        OreDictionary.registerOre((String)"dustThermite", (Item)ModItems.THERMITE_DUST);
        OreDictionary.registerOre((String)"dustPhosphorus", (Item)ModItems.PHOSPHORUS);
        OreDictionary.registerOre((String)"oreSulfur", (Block)ModBlocks.oreSulfur);
        OreDictionary.registerOre((String)"orePhosphorus", (Block)ModBlocks.orePhosphorite);
        OreDictionary.registerOre((String)"oreTar", (Block)ModBlocks.oreTar);
        OreDictionary.registerOre((String)"orePotash", (Block)ModBlocks.orePotash);
        OreDictionary.registerOre((String)"blockCharcoal", (Block)ModBlocks.blockCharcoal);
        OreDictionary.registerOre((String)"blockBitumen", (Block)ModBlocks.blockBitumen);
        OreDictionary.registerOre((String)"blockSulfur", (Block)ModBlocks.blockSulfur);
    }

    public static void initOreDict(IForgeRegistryEntry.Impl<?> itemOrBlock) {
        String[] words = itemOrBlock.getRegistryName().func_110623_a().split("_");
        String oreName = "ore";
        for (String word : words) {
            if ("ore".equals(word)) continue;
            oreName = oreName.concat(Utils.capitalize(word));
        }
        if (itemOrBlock instanceof Block) {
            OreDictionary.registerOre((String)oreName, (Block)((Block)itemOrBlock));
        } else if (itemOrBlock instanceof Item) {
            OreDictionary.registerOre((String)oreName, (Item)((Item)itemOrBlock));
        }
    }

    public static void populateOredictCache() {
        ModMetals.metalMap.forEach((name, metal) -> {
            ALLOYING_CACHE.putAll(metal, OreDictHandler.getOredictedStacksFromMetalAndPrefix("ingot", metal));
            ALLOYING_CACHE.putAll(metal, OreDictHandler.getOredictedStacksFromMetalAndPrefix("dust", metal));
        });
    }

    public static NonNullList<ItemStack> getOredictedStacksFromMetalAndPrefix(String prefix, Metal metal) {
        String camelMetal = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, metal.toString());
        return OreDictionary.getOres((String)(prefix + camelMetal));
    }

    public static boolean containsPrefix(ItemStack stack, String prefix) {
        return Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack)).anyMatch(id -> OreDictionary.getOreName((int)id).startsWith(prefix));
    }
}

