/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.gui.hud;

import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.recipe.SublimationRecipes;
import it.hurts.metallurgy_reforged.tileentity.TileEntityChamber;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class SublimationChamberHUD {
    public static void render(RenderGameOverlayEvent.Post event, Minecraft minecraft, BlockPos pos) {
        ItemStack fuel;
        WorldClient world = minecraft.field_71441_e;
        if (!(world.func_175625_s(pos) instanceof TileEntityChamber)) {
            return;
        }
        ScaledResolution resolution = event.getResolution();
        int x = resolution.func_78326_a() / 2;
        int y = resolution.func_78328_b() / 2;
        TileEntityChamber te = (TileEntityChamber)world.func_175625_s(pos);
        Map<ItemStack, PotionEffect> recipes = SublimationRecipes.getInstance().recipesMap();
        ItemStack metalStack = te.func_70301_a(0);
        if (!metalStack.func_190926_b()) {
            RenderHelper.func_74519_b();
            minecraft.func_175599_af().func_175042_a(metalStack, x - 40, y - 7);
            RenderHelper.func_74518_a();
            minecraft.field_71466_p.func_175063_a(String.valueOf(metalStack.func_190916_E()), (float)(x - 50), (float)(y - 3), 0xFFFFFF);
        }
        if (!(fuel = te.func_70301_a(1)).func_190926_b()) {
            RenderHelper.func_74519_b();
            minecraft.func_175599_af().func_175042_a(fuel, x - 5, y + 17);
            RenderHelper.func_74518_a();
            minecraft.field_71466_p.func_175063_a(String.valueOf(fuel.func_190916_E()), (float)(x - 15), (float)(y + 20), 0xFFFFFF);
        }
        if (te.potionEffect != null) {
            PotionEffect effect = null;
            for (Map.Entry<ItemStack, PotionEffect> recipe : recipes.entrySet()) {
                if (recipe.getKey().func_77973_b() != metalStack.func_77973_b()) continue;
                effect = recipe.getValue();
                metalStack.func_190920_e(recipe.getKey().func_190916_E());
            }
            if (effect != null) {
                int effectIndex = effect.func_188419_a().func_76392_e();
                GlStateManager.func_179094_E();
                minecraft.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
                Utils.drawTexturedModalRect(x + 30, y - 10, 141, 166, 24, 24);
                Utils.drawTexturedModalRect(x + 33, y - 7, effectIndex % 8 * 18, 198 + effectIndex / 8 * 18, 18, 18);
                Metal metal = ItemUtils.getMetalFromItem(metalStack.func_77973_b());
                int color = metal != null ? metal.getStats().getColorHex() : 0xFFFFFF;
                minecraft.field_71466_p.func_175063_a(te.activeTime / 20 + " " + Utils.localizeIgnoreFormat("gui.jei_compat.sublimation_chamber.seconds"), (float)(x - 33), (float)(y - 30), color);
                minecraft.field_71466_p.func_175063_a(Utils.localizeIgnoreFormat(effect.func_76453_d()), (float)(x + 30), (float)(y + 25), color);
                GlStateManager.func_179121_F();
            }
        }
    }
}

