/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.entity.ai;

import it.hurts.metallurgy_reforged.entity.EntityPierKnight;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AIPierKnightFollow
extends EntityAIBase {
    private final EntityPierKnight follower;
    private EntityLivingBase owner;
    World world;
    private final double followSpeed = 1.1;
    private final PathNavigate pierPathFinder;
    private int timeToRecalcPath;
    float maxDist = 2.0f;
    float minDist = 10.0f;
    private float oldWaterCost;

    public AIPierKnightFollow(EntityPierKnight fellowPier) {
        this.follower = fellowPier;
        this.world = fellowPier.field_70170_p;
        this.pierPathFinder = fellowPier.func_70661_as();
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        Entity entity = this.follower.func_70902_q();
        if (entity == null) {
            return false;
        }
        if (this.follower.func_70638_az() != null) {
            return false;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
            return false;
        }
        if (this.follower.func_70068_e(entity) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = (EntityLivingBase)entity;
        return true;
    }

    public boolean func_75253_b() {
        return !this.pierPathFinder.func_75500_f() && this.follower.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.follower.func_184643_a(PathNodeType.WATER);
        this.follower.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.pierPathFinder.func_75499_g();
        this.follower.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.follower.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.follower.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.pierPathFinder.func_75497_a((Entity)this.owner, this.followSpeed) && this.follower.func_70068_e((Entity)this.owner) >= 144.0) {
                int i = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, k, l, i1)) continue;
                        this.follower.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.follower.field_70177_z, this.follower.field_70125_A);
                        this.pierPathFinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState iblockstate = this.world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.world, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.follower) && this.world.func_175623_d(blockpos.func_177984_a()) && this.world.func_175623_d(blockpos.func_177981_b(2));
    }
}

