/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.entity;

import it.hurts.metallurgy_reforged.world.explosive.ExplosiveType;
import it.hurts.metallurgy_reforged.world.explosive.MetallurgyExplosion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class MetallurgyPrimedTNT
extends EntityTNTPrimed {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(MetallurgyPrimedTNT.class, (DataSerializer)DataSerializers.field_187192_b);
    private ExplosiveType explosionType;

    public MetallurgyPrimedTNT(World worldIn) {
        super(worldIn);
    }

    public MetallurgyPrimedTNT(World worldIn, double x, double y, double z, EntityLivingBase igniter, ExplosiveType explosionType) {
        super(worldIn, x, y, z, igniter);
        this.explosionType = explosionType;
        this.field_70180_af.func_187227_b(TYPE, (Object)explosionType.ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)-1);
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("tnt_type", this.explosionType.ordinal());
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.explosionType = ExplosiveType.byIndex(compound.func_74762_e("tnt_type"));
    }

    public void func_184206_a(@Nonnull DataParameter<?> key) {
        super.func_184206_a(key);
        if (TYPE == key) {
            this.explosionType = ExplosiveType.byIndex((Integer)this.field_70180_af.func_187225_a(TYPE));
        }
    }

    protected void func_70515_d() {
        MetallurgyExplosion.newExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionType);
    }

    @ParametersAreNonnullByDefault
    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        if (this.explosionType == ExplosiveType.VULCANITE && blockStateIn.func_185904_a() == Material.field_151576_e) {
            return blockStateIn.func_177230_c().getExplosionResistance(this.field_70170_p, pos, (Entity)this, explosionIn) / 7.0f;
        }
        return super.func_180428_a(explosionIn, worldIn, pos, blockStateIn);
    }

    @Nullable
    public ExplosiveType getType() {
        return ExplosiveType.byIndex((Integer)this.field_70180_af.func_187225_a(TYPE));
    }
}

