/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Streams;
import it.hurts.metallurgy_reforged.effect.MetallurgyEffects;
import it.hurts.metallurgy_reforged.entity.ai.AIPierKnightFollow;
import it.hurts.metallurgy_reforged.entity.ai.AIPierOwnerAttack;
import it.hurts.metallurgy_reforged.entity.ai.AIPierOwnerWasHurt;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.item.tool.EnumTools;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.client.PacketSpawnVanillaParticles;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPierKnight
extends EntityCreature
implements IEntityOwnable {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityPierKnight.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> THICKNESS = EntityDataManager.func_187226_a(EntityPierKnight.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Boolean> IS_PUTIN = EntityDataManager.func_187226_a(EntityPierKnight.class, (DataSerializer)DataSerializers.field_187198_h);
    private int timeUntilDeath = 20;
    private int vanishTime = 40;

    public EntityPierKnight(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
    }

    public EntityPierKnight(World worldIn, EntityLivingBase owner, EntityLivingBase attacker, byte thickness) {
        this(worldIn);
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.of((Object)owner.func_110124_au()));
        this.func_70624_b(attacker);
        this.timeUntilDeath = 600;
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(ModMetals.DAMASCUS_STEEL.getTool(EnumTools.SWORD)));
        this.setThickness(thickness);
        boolean isPutin = Streams.stream((Iterable)owner.func_184193_aE()).anyMatch(item -> item.func_82833_r().toLowerCase().contains("putin"));
        this.field_70180_af.func_187227_b(IS_PUTIN, (Object)isPutin);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(THICKNESS, (Object)1);
        this.field_70180_af.func_187214_a(IS_PUTIN, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIPierKnightFollow(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIPierOwnerWasHurt(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIPierOwnerAttack(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a((double)((Byte)this.field_70180_af.func_187225_a(THICKNESS) * 2));
    }

    @Nullable
    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setThickness((Byte)this.field_70180_af.func_187225_a(THICKNESS));
        this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(ModMetals.DAMASCUS_STEEL.getTool(EnumTools.SWORD)));
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Nonnull
    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    @Nullable
    public EntityItem func_70099_a(@Nonnull ItemStack stack, float offsetY) {
        return null;
    }

    protected boolean func_184228_n(@Nonnull Entity entityIn) {
        return false;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70170_p.field_72995_K) {
            this.playVanishParticle((Entity)this, false);
            this.playVanishParticle(this.func_70902_q(), true);
        }
        if (this.field_70725_aQ >= 40) {
            this.func_70106_y();
        }
    }

    public boolean func_175446_cd() {
        return this.vanishTime > 0 || super.func_175446_cd();
    }

    public boolean func_184652_a(@Nonnull EntityPlayer player) {
        return false;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        EntityLivingBase owner = (EntityLivingBase)this.func_70902_q();
        if (owner == null) {
            return;
        }
        if (owner.getEntityData().func_74767_n("has_pier")) {
            owner.getEntityData().func_74757_a("has_pier", false);
            if (owner instanceof EntityPlayer) {
                for (ItemArmorBase armorItem : ModMetals.DAMASCUS_STEEL.getArmorSet()) {
                    ((EntityPlayer)owner).func_184811_cZ().func_185145_a((Item)armorItem, 200);
                }
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        if (!this.field_70170_p.field_72995_K) {
            if (this.vanishTime == 0 && this.func_70638_az() == null) {
                --this.timeUntilDeath;
            }
            boolean canPierExist = MetallurgyEffects.DAMASCUS_STEEL_ARMOR_EFFECT.canBeApplied((EntityLivingBase)this.func_70902_q());
            if (this.timeUntilDeath <= 0 || !canPierExist) {
                this.func_70097_a(DamageSource.field_76377_j, 2.1474836E9f);
            }
        }
        if (this.vanishTime > 0) {
            if (this.field_70170_p.field_72995_K) {
                this.playVanishParticle((Entity)this, true);
                this.playVanishParticle(this.func_70902_q(), false);
            }
            --this.vanishTime;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playVanishParticle(Entity entity, boolean in) {
        if (entity == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            double particleX = entity.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)entity.field_70130_N;
            double particleY = entity.field_70163_u + this.field_70146_Z.nextDouble() * (double)entity.field_70131_O;
            double particleZ = entity.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)entity.field_70130_N;
            Vec3d center = entity.func_174813_aQ().func_189972_c();
            Vec3d particleVec = new Vec3d(particleX, particleY, particleZ);
            Vec3d motion = in ? center.func_178788_d(particleVec).func_186678_a(0.1) : particleVec.func_178788_d(center).func_186678_a(0.2);
            PacketSpawnVanillaParticles packet = new PacketSpawnVanillaParticles(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), (float)particleX, (float)particleY, (float)particleZ, (float)motion.field_72450_a, (float)motion.field_72448_b, (float)motion.field_72449_c);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), particleX, particleY, particleZ, 64.0);
            PacketManager.network.sendToAllTracking((IMessage)packet, point);
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        this.timeUntilDeath = 600;
        super.func_70624_b(entitylivingbaseIn);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void setThickness(byte thickness) {
        this.field_70180_af.func_187227_b(THICKNESS, (Object)thickness);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(10 * thickness));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(2 * thickness));
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    @Nullable
    public Entity func_70902_q() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null || this.field_70170_p.field_72995_K ? null : ((WorldServer)this.field_70170_p).func_175733_a(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getVanishTime() {
        return this.vanishTime;
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("OwnerUUID", 8)) {
            Optional thing = Optional.of((Object)UUID.fromString(compound.func_74779_i("OwnerUUID")));
            this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)thing);
        }
        this.setThickness(compound.func_74771_c("PierThickness"));
        if (compound.func_74764_b("PierLifespan")) {
            this.timeUntilDeath = compound.func_74762_e("PierLifespan");
        }
        this.field_70180_af.func_187227_b(IS_PUTIN, (Object)compound.func_74767_n("WidePutin"));
        this.vanishTime = compound.func_74762_e("VanishTime");
    }

    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_184753_b() != null) {
            compound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
        compound.func_74774_a("PierThickness", ((Byte)this.field_70180_af.func_187225_a(THICKNESS)).byteValue());
        compound.func_74768_a("PierLifespan", this.timeUntilDeath);
        compound.func_74757_a("WidePutin", ((Boolean)this.field_70180_af.func_187225_a(IS_PUTIN)).booleanValue());
        compound.func_74768_a("VanishTime", this.vanishTime);
    }
}

