/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VulcaniteWeaponEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public VulcaniteWeaponEffect() {
        super(ModMetals.VULCANITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        if (step == maxSteps) {
            float currentCooldown = entity.func_184811_cZ().func_185143_a(entity.func_184614_ca().func_77973_b(), 0.0f);
            float explosionPower = 0.8f;
            world.func_72876_a(null, entity.field_70165_t, entity.field_70163_u + 0.65, entity.field_70161_v, explosionPower, false);
            if (entity.func_184614_ca().func_77978_p() != null) {
                entity.func_184614_ca().func_77978_p().func_74757_a("primed", false);
            }
        }
    }

    @Override
    public void rightClickHandler(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack weapon = playerIn.func_184614_ca();
        CooldownTracker cooldownTracker = playerIn.func_184811_cZ();
        if (cooldownTracker.func_185143_a(weapon.func_77973_b(), 0.0f) > 0.0f) {
            return;
        }
        playerIn.func_184185_a(SoundEvents.field_187904_gd, 0.75f, 1.25f);
        NBTTagCompound data = weapon.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        data.func_74757_a("primed", true);
        weapon.func_77982_d(data);
        this.getBundle(playerIn, this.metal, this.getCategory()).incrementStep(null);
        cooldownTracker.func_185145_a(weapon.func_77973_b(), 50);
    }

    @SubscribeEvent
    public void explodeEnemy(LivingDamageEvent event) {
        Entity sourceEnt = event.getSource().func_76364_f();
        if (sourceEnt instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)sourceEnt;
            if (!this.canBeApplied(attacker)) {
                return;
            }
            NBTTagCompound data = attacker.func_184614_ca().func_77978_p();
            if (data == null) {
                return;
            }
            if (data.func_74767_n("primed")) {
                data.func_74757_a("primed", false);
                if (attacker instanceof EntityPlayer) {
                    this.getBundle((EntityPlayer)attacker, this.metal, this.getCategory()).resetProgress((EntityPlayer)attacker);
                }
                EntityLivingBase target = event.getEntityLiving();
                float currentCooldown = attacker instanceof EntityPlayer ? ((EntityPlayer)attacker).func_184811_cZ().func_185143_a(attacker.func_184614_ca().func_77973_b(), 0.0f) : 100.0f;
                float explosionPower = 0.32f + (1.0f - currentCooldown) * 1.1f;
                attacker.field_70170_p.func_72876_a((Entity)attacker, target.field_70165_t, target.field_70163_u, target.field_70161_v, explosionPower, false);
                target.func_70653_a((Entity)attacker, 2.0f, attacker.field_70165_t - target.field_70165_t, attacker.field_70161_v - target.field_70161_v);
            }
        }
    }
}

