/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.capabilities.effect.ProgressiveDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ShadowSteelWeaponEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    private static final UUID ATTACK_SPEED_UUID = UUID.fromString("91AEAB56-376B-1298-935B-2F7F68070666");
    private final IntFunction<AttributeModifier> generateAttackSpeedMod = darkness -> new AttributeModifier(ATTACK_SPEED_UUID, "Shadow_Steel_Attack_Speed_mod", (double)(darkness - 8), 0);

    public ShadowSteelWeaponEffect() {
        super(ModMetals.SHADOW_STEEL);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @SubscribeEvent
    public void buffAttackDmgSpeed(LivingHurtEvent event) {
        Entity sourceEnt = event.getSource().func_76364_f();
        if (sourceEnt instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)sourceEnt;
            if (!this.canBeApplied(attacker)) {
                return;
            }
            float darkness = EventUtils.getDarknessLevel((Entity)attacker, 15.0f);
            if (darkness >= 8.0f) {
                if (attacker instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)attacker;
                    ProgressiveDataBundle bundle = this.getBundle(player, this.metal, this.getCategory());
                    if (!bundle.isEffectInProgress()) {
                        attacker.func_110148_a(SharedMonsterAttributes.field_188790_f).func_188479_b(ATTACK_SPEED_UUID);
                        bundle.incrementStep(player);
                        attacker.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(this.generateAttackSpeedMod.apply(Math.round(darkness)));
                    }
                    player.func_184821_cY();
                }
            } else if (darkness <= 6.0f) {
                event.setAmount(event.getAmount() + (6.0f - darkness));
            }
        }
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        if (step == maxSteps) {
            entity.func_110148_a(SharedMonsterAttributes.field_188790_f).func_188479_b(ATTACK_SPEED_UUID);
        }
    }
}

