/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import com.google.common.util.concurrent.AtomicDouble;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SanguiniteWeaponEffect
extends BaseMetallurgyEffect {
    public SanguiniteWeaponEffect() {
        super(ModMetals.SANGUINITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    private void devour(EntityLivingBase target, DamageSource source, AtomicDouble damageOrMaxHealth, boolean deathEvent) {
        Entity sourceEnt = source.func_76364_f();
        if (sourceEnt instanceof EntityPlayer) {
            EntityPlayer attacker = (EntityPlayer)sourceEnt;
            if (!this.canBeApplied((EntityLivingBase)attacker)) {
                return;
            }
            if (!deathEvent) {
                int voracityLevel = 20 - attacker.func_71024_bL().func_75116_a();
                damageOrMaxHealth.set(Math.min(damageOrMaxHealth.get() + (double)voracityLevel, 20.0));
                for (int i = 0; i < 10; ++i) {
                    this.spawnParticle((Entity)target, 2.0f, true, 6);
                }
            } else {
                int newLevel = attacker.func_71024_bL().func_75116_a() + Math.round(damageOrMaxHealth.floatValue() / 5.0f);
                attacker.func_71024_bL().func_75114_a(newLevel);
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 80));
            }
        }
    }

    @SubscribeEvent
    public void devourHit(LivingHurtEvent event) {
        AtomicDouble amount = new AtomicDouble((double)event.getAmount());
        this.devour(event.getEntityLiving(), event.getSource(), amount, false);
        event.setAmount(amount.floatValue());
    }

    @SubscribeEvent
    public void devourKill(LivingDeathEvent event) {
        this.devour(event.getEntityLiving(), event.getSource(), new AtomicDouble((double)event.getEntityLiving().func_110138_aP()), true);
    }
}

