/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.capabilities.effect.ProgressiveDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class QuicksilverWeaponEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public QuicksilverWeaponEffect() {
        super(ModMetals.QUICKSILVER);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @SubscribeEvent
    public void swiftStrike(LivingDamageEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource().func_76364_f() instanceof EntityPlayer) {
            EntityPlayer attacker = (EntityPlayer)event.getSource().func_76364_f();
            if (!this.canBeApplied((EntityLivingBase)attacker)) {
                return;
            }
            ProgressiveDataBundle bundle = this.getBundle(attacker, this.metal, this.getCategory());
            if (!bundle.isEffectInProgress()) {
                bundle.incrementStep(attacker);
            }
        }
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        if (step < maxSteps) {
            EntityLivingBase lastAttackedEntity = entity.func_110144_aD();
            if (lastAttackedEntity != null) {
                ExtraFilledDataBundle bundle;
                if (step == 1) {
                    bundle = this.getEffectCapability((EntityPlayer)entity).quicksilverWeaponBundle;
                    Vec3d velocity = entity.func_174791_d().func_72444_a(lastAttackedEntity.func_174791_d()).func_186678_a(0.6);
                    bundle.setExtra("velocity_x", (float)velocity.field_72450_a);
                    bundle.setExtra("velocity_y", (float)velocity.field_72448_b);
                    bundle.setExtra("velocity_z", (float)velocity.field_72449_c);
                }
                bundle = this.getEffectCapability((EntityPlayer)entity).quicksilverWeaponBundle;
                entity.field_70159_w = bundle.getExtraFloat("velocity_x");
                entity.field_70181_x = bundle.getExtraFloat("velocity_y");
                entity.field_70179_y = bundle.getExtraFloat("velocity_z");
                entity.field_70133_I = true;
                if (lastAttackedEntity.func_174813_aQ().func_72326_a(entity.func_174813_aQ())) {
                    lastAttackedEntity.field_70172_ad = 0;
                    lastAttackedEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)entity), 4.0f);
                    for (int i = 0; i < 10; ++i) {
                        this.spawnParticle((Entity)lastAttackedEntity, 2.0f, true, 5);
                    }
                }
                entity.func_184224_h(true);
            }
        } else {
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70133_I = true;
            entity.func_184224_h(false);
        }
    }
}

