/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.capabilities.effect.ProgressiveDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.item.tool.IToolEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MithrilWeaponEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public MithrilWeaponEffect() {
        super(ModMetals.MITHRIL);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @SubscribeEvent
    public void startMagicalDmgDelay(LivingDamageEvent event) {
        Entity sourceEnt = event.getSource().func_76364_f();
        if (sourceEnt instanceof EntityPlayer && this.canBeApplied((EntityLivingBase)sourceEnt)) {
            EntityPlayer player = (EntityPlayer)sourceEnt;
            ProgressiveDataBundle effBundle = this.getBundle(player, this.metal, this.getCategory());
            if (effBundle.isEffectInProgress()) {
                return;
            }
            effBundle.setEffectStack(player.func_184614_ca(), null);
            effBundle.incrementStep(player);
        }
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        if (!effectStack.func_190926_b() && effectStack.func_77973_b() instanceof IToolEffect) {
            IToolEffect tool = (IToolEffect)effectStack.func_77973_b();
            float attackDamage = tool.getMetalStats().getToolStats().getDamage() * 0.3f;
            EntityLivingBase target = entity.func_110144_aD();
            if (target != null && !target.field_70128_L) {
                target.func_70097_a(DamageSource.field_76376_m, Math.max(1.0f, attackDamage));
                for (int i = 0; i < 10; ++i) {
                    double r1 = Math.random() * 0.15 - 0.075;
                    double r2 = Math.random() * 0.15 - 0.075;
                    double r3 = Math.random() * 0.15 - 0.075;
                    this.spawnParticle(world, target.field_70165_t, target.field_70163_u + 0.6 * (double)target.field_70131_O, target.field_70161_v, r1, r2, r3, 2.0f, true, 6);
                }
            }
        }
    }
}

