/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MidasiumWeaponEffect
extends BaseMetallurgyEffect {
    public MidasiumWeaponEffect() {
        super(ModMetals.MIDASIUM);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @SubscribeEvent
    public void lootingAndGreed(LivingDropsEvent event) {
        Entity sourceEnt = event.getSource().func_76364_f();
        if (sourceEnt instanceof EntityLivingBase && this.canBeApplied((EntityLivingBase)sourceEnt)) {
            float chance = (float)(event.getLootingLevel() + 1) * 0.3f;
            if (Math.random() <= (double)chance) {
                ArrayList equipList = new ArrayList();
                event.getEntityLiving().func_184209_aF().forEach(equipList::add);
                event.getDrops().forEach(drop -> {
                    if (!equipList.contains(drop.func_92059_d())) {
                        MidasiumWeaponEffect.applyGreedEffect(drop, event.getLootingLevel());
                    }
                });
                this.spawnParticle(event.getEntity().field_70170_p, event.getEntity().func_180425_c(), 1.0f, true, 5, Math.random() * 0.1 - 0.05, Math.random() * 0.1 - 0.05, Math.random() * 0.1 - 0.05);
            }
        }
    }

    public static void applyGreedEffect(EntityItem drop, int fortuneLootingLevel) {
        if (Math.random() <= 0.03 + (double)fortuneLootingLevel * 0.05) {
            drop.func_92058_a(new ItemStack(Items.field_151043_k, drop.func_92059_d().func_190916_E()));
        } else {
            float doubleIncreaseChance = (float)fortuneLootingLevel / (float)fortuneLootingLevel + 1.0f;
            ItemStack dropStack = drop.func_92059_d();
            int increaseAmount = Math.random() <= (double)doubleIncreaseChance ? 1 : 2;
            dropStack.func_190920_e(dropStack.func_190916_E() + increaseAmount);
        }
    }

    public static class StackWrapperImpl
    extends EntityItem
    implements StackWrapper {
        private ItemStack item;

        public StackWrapperImpl(ItemStack stack) {
            super(null);
            this.item = stack;
        }

        @Nonnull
        public ItemStack func_92059_d() {
            return this.item;
        }

        public void func_92058_a(@Nonnull ItemStack stack) {
            this.item = stack;
        }
    }

    private static interface StackWrapper {
        public ItemStack getItem();

        public void setItem(ItemStack var1);
    }
}

