/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.MetallurgyEffects;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class HaderothWeaponEffect
extends BaseMetallurgyEffect {
    public HaderothWeaponEffect() {
        super(ModMetals.HADEROTH);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @Override
    public Pair<String, String> getTooltip() {
        Pair<String, String> tooltip = super.getTooltip();
        if (!MetallurgyEffects.HADEROTH_EFFECT.isEnabled()) {
            int firstBreak = ((String)tooltip.getRight()).indexOf("\n");
            String trimmed = ((String)tooltip.getRight()).substring(firstBreak + 1);
            tooltip.setValue((Object)trimmed);
        }
        return tooltip;
    }

    @SubscribeEvent
    public void handleKillStreak(LivingDeathEvent event) {
        Entity source = event.getSource().func_76364_f();
        if (source instanceof EntityLivingBase && this.canBeApplied((EntityLivingBase)source)) {
            ItemStack toolStack = ((EntityLivingBase)source).func_184614_ca();
            NBTTagCompound compound = toolStack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            if (MetallurgyEffects.HADEROTH_EFFECT.isEnabled() && !compound.func_74767_n("reborn")) {
                return;
            }
            ResourceLocation targetRegName = this.getMobType(event.getEntity());
            if (targetRegName != null) {
                String killedType = compound.func_74779_i("killed_type");
                if (killedType.equals(targetRegName.toString())) {
                    compound.func_74768_a("kill_count", compound.func_74762_e("kill_count") + 1);
                } else {
                    compound.func_74768_a("kill_count", 1);
                    compound.func_74778_a("killed_type", targetRegName.toString());
                }
            }
            toolStack.func_77982_d(compound);
        }
    }

    @SubscribeEvent
    public void applyEffectModifier(LivingHurtEvent event) {
        NBTTagCompound toolData;
        Entity source = event.getSource().func_76364_f();
        if (source instanceof EntityLivingBase && this.canBeApplied((EntityLivingBase)source) && (toolData = ((EntityLivingBase)source).func_184614_ca().func_77978_p()) != null) {
            ResourceLocation targetType = this.getMobType(event.getEntity());
            int killCount = toolData.func_74762_e("kill_count");
            if (killCount > 0 && targetType != null && toolData.func_74779_i("killed_type").equals(targetType.toString())) {
                event.setAmount(Math.min(event.getAmount() + (float)killCount, 12.0f));
                for (int i = 0; i < 15; ++i) {
                    this.spawnParticle(event.getEntity(), 2.0f, true, 5);
                }
            }
        }
    }

    @Nullable
    private ResourceLocation getMobType(Entity entity) {
        ResourceLocation targetRegName = null;
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            if (entry.getEntityClass() != entity.getClass()) continue;
            targetRegName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entry);
        }
        return targetRegName;
    }
}

