/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ElectrumWeaponEffect
extends BaseMetallurgyEffect {
    public ElectrumWeaponEffect() {
        super(ModMetals.ELECTRUM);
        IItemPropertyGetter condition = (stack, worldIn, entityIn) -> stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("magnet") ? 1.0f : 0.0f;
        this.setupModelOverrides(condition);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @Override
    public void rightClickHandler(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack toolStack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            worldIn.func_184134_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187787_eV, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
        if (playerIn.func_184811_cZ().func_185143_a(toolStack.func_77973_b(), 1.0f) != 0.0f) {
            return;
        }
        Predicate TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, Entity::func_70067_L});
        Vec3d longLook = playerIn.func_70040_Z().func_186678_a(8.0);
        List entitiesToTest = playerIn.field_70170_p.func_175674_a((Entity)playerIn, playerIn.func_174813_aQ().func_72321_a(longLook.field_72450_a, longLook.field_72448_b, longLook.field_72449_c), TARGETS);
        Optional<Entity> optionalTarget = entitiesToTest.stream().filter(e -> {
            AxisAlignedBB aabb = e.func_174813_aQ().func_186662_g((double)0.3f);
            RayTraceResult result = aabb.func_72327_a(playerIn.func_174824_e(1.0f), playerIn.func_174824_e(1.0f).func_178787_e(longLook));
            return result != null;
        }).min((e1, e2) -> {
            double d1 = playerIn.func_174791_d().func_72438_d(e1.func_174791_d());
            double d2 = playerIn.func_174791_d().func_72438_d(e2.func_174791_d());
            return Double.compare(d1, d2);
        });
        if (optionalTarget.isPresent()) {
            Vec3d lookVec = playerIn.func_70040_Z();
            Entity target = optionalTarget.get();
            Vec3d targetToPlayer = target.func_174824_e(1.0f).func_178788_d(playerIn.func_174824_e(1.0f));
            target.field_70159_w = -lookVec.field_72450_a * targetToPlayer.func_72433_c() * 0.25;
            target.field_70181_x = -lookVec.field_72448_b * targetToPlayer.func_72433_c() * 0.25;
            target.field_70179_y = -lookVec.field_72449_c * targetToPlayer.func_72433_c() * 0.25;
            target.field_70133_I = true;
            int density = (int)(targetToPlayer.func_72433_c() * 5.0);
            for (int i = 0; i < density; ++i) {
                double unitX = targetToPlayer.field_72450_a * (double)i / (double)density;
                double unitY = targetToPlayer.field_72448_b * (double)i / (double)density;
                double unitZ = targetToPlayer.field_72449_c * (double)i / (double)density;
                this.spawnParticle(playerIn.field_70170_p, playerIn.field_70165_t + unitX, playerIn.field_70163_u + (double)playerIn.func_70047_e() + unitY, playerIn.field_70161_v + unitZ, 1.5f, true, 3);
            }
            playerIn.func_184811_cZ().func_185145_a(toolStack.func_77973_b(), 120);
        }
    }
}

