/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CelenegilWeaponEffect
extends BaseMetallurgyEffect {
    public CelenegilWeaponEffect() {
        super(ModMetals.CELENEGIL);
        IItemPropertyGetter condition = (stack, worldIn, entityIn) -> stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("glory_seeker") ? 1.0f : 0.0f;
        this.setupModelOverrides(condition);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @SubscribeEvent
    public void playerAttack(LivingDamageEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            float cooldown;
            EntityLivingBase entity = (EntityLivingBase)event.getSource().func_76346_g();
            if (!this.canBeApplied(entity)) {
                return;
            }
            ItemStack weapon = entity.func_184614_ca();
            if (entity instanceof EntityPlayer && (cooldown = ((EntityPlayer)entity).func_184811_cZ().func_185143_a(weapon.func_77973_b(), 0.0f)) > 0.0f) {
                event.setCanceled(true);
                return;
            }
            if (weapon.func_77978_p() == null) {
                weapon.func_77982_d(new NBTTagCompound());
            }
            if (weapon.func_77978_p().func_74767_n("glory_seeker")) {
                event.setAmount(event.getAmount() * 1.35f);
                if (event.getEntityLiving().func_110143_aJ() - event.getAmount() <= 0.0f) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 160, 0));
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 160, 0));
                } else if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_184811_cZ().func_185145_a(weapon.func_77973_b(), 100);
                }
            }
        }
    }

    @Override
    public void rightClickHandler(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack tool = playerIn.func_184586_b(handIn);
        NBTTagCompound toolData = tool.func_77978_p();
        if (toolData == null) {
            toolData = new NBTTagCompound();
        }
        boolean newState = !toolData.func_74767_n("glory_seeker");
        toolData.func_74757_a("glory_seeker", newState);
        if (worldIn.field_72995_K) {
            worldIn.func_184134_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, newState ? 1.0f : 0.5f, false);
        }
        tool.func_77982_d(toolData);
    }
}

