/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CarmotWeaponEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public CarmotWeaponEffect() {
        super(ModMetals.CARMOT);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @SubscribeEvent
    public void chainAttack(LivingHurtEvent event) {
        Entity tSource = event.getSource().func_76346_g();
        if (tSource instanceof EntityPlayer) {
            EntityPlayer attacker = (EntityPlayer)tSource;
            if (!this.canBeApplied((EntityLivingBase)attacker)) {
                return;
            }
            EntityLivingBase attacked = event.getEntityLiving();
            ExtraFilledDataBundle data = this.getEffectCapability((EntityPlayer)attacker).carmotWeaponBundle;
            int id = attacked.func_145782_y();
            data.setExtra("id", id);
            data.setExtra("amount", event.getAmount());
            data.incrementStep(attacker);
        }
    }

    @Override
    public void onStep(World world, EntityPlayer attacker, ItemStack effectStack, int maxSteps, int step) {
        ExtraFilledDataBundle data = this.getEffectCapability((EntityPlayer)attacker).carmotWeaponBundle;
        int attackedId = data.getExtraInt("id");
        Entity attacked = world.func_73045_a(attackedId);
        if (!(attacked instanceof EntityLivingBase)) {
            return;
        }
        attacker.field_70170_p.func_72872_a(attacked.getClass(), new AxisAlignedBB(attacked.field_70165_t - 2.0, attacked.field_70163_u - 2.0, attacked.field_70161_v - 2.0, attacked.field_70165_t + 2.0, attacked.field_70163_u + 2.0, attacked.field_70161_v + 2.0)).forEach(entity -> {
            if (entity != attacked) {
                entity.func_70097_a(DamageSource.field_76377_j, (float)data.getExtraInt("amount"));
                for (int i = 0; i < 5; ++i) {
                    this.spawnParticle((Entity)entity, 1.5f, true, 3);
                }
            }
        });
    }
}

