/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.weapon;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AtlarusWeaponEffect
extends BaseMetallurgyEffect {
    private static final int RANGE = 5;

    public AtlarusWeaponEffect() {
        super(ModMetals.ATLARUS);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.WEAPON;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        if (!this.canBeApplied((EntityLivingBase)player)) {
            return;
        }
        AxisAlignedBB box = new AxisAlignedBB(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t, player.field_70163_u, player.field_70161_v).func_186662_g(5.0);
        player.func_184609_a(event.getHand());
        for (Entity entity : world.func_72839_b((Entity)player, box)) {
            Vec3d motionVector = new Vec3d(entity.field_70165_t - player.field_70165_t, 0.6, entity.field_70161_v - player.field_70161_v).func_72432_b();
            if (!world.field_72995_K) {
                entity.field_70159_w += motionVector.field_72450_a * 1.5;
                entity.field_70181_x += motionVector.field_72448_b;
                entity.field_70179_y += motionVector.field_72449_c * 1.5;
                entity.field_70133_I = true;
                continue;
            }
            for (int i = 0; i < 4; ++i) {
                double particleX = entity.field_70165_t + (Math.random() - 0.5) * (double)entity.field_70130_N;
                double particleY = entity.field_70163_u + Math.random() * (double)entity.field_70131_O;
                double particleZ = entity.field_70161_v + (Math.random() - 0.5) * (double)entity.field_70130_N;
                world.func_175688_a(EnumParticleTypes.CLOUD, particleX, particleY, particleZ, motionVector.field_72450_a, 0.0, motionVector.field_72449_c, new int[0]);
            }
        }
        BlockPos playerPos = player.func_180425_c();
        BlockPos.func_177980_a((BlockPos)playerPos.func_177982_a(-5, -5, -5), (BlockPos)playerPos.func_177982_a(5, 5, 5)).forEach(pos -> {
            IBlockState state = world.func_180495_p(pos);
            if ((state.func_177230_c() instanceof BlockLeaves || state.func_177230_c() instanceof BlockVine) && !world.field_72995_K) {
                world.func_175655_b(pos, true);
            }
        });
        if (!world.field_72995_K) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187606_E, SoundCategory.AMBIENT, 1.0f, 0.75f);
        }
        for (int i = 0; i < 60; ++i) {
            world.func_175688_a(EnumParticleTypes.CLOUD, player.field_70165_t, player.field_70163_u + 0.4, player.field_70161_v, 0.7 - Math.random() * 1.4, 0.1, 0.7 - Math.random() * 1.4, new int[0]);
        }
        player.func_184811_cZ().func_185145_a(event.getItemStack().func_77973_b(), 40);
    }
}

