/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.BlockUtils;
import it.hurts.metallurgy_reforged.util.EventUtils;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VulcaniteToolEffect
extends BaseMetallurgyEffect {
    public VulcaniteToolEffect() {
        super(ModMetals.VULCANITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.TOOL;
    }

    @SubscribeEvent
    public void handleFissure(BlockEvent.BreakEvent event) {
        if (!this.canBeApplied((EntityLivingBase)event.getPlayer())) {
            return;
        }
        ItemStack toolStack = event.getPlayer().func_184614_ca();
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)toolStack);
        if (Math.random() < 0.4 + 0.2 * (double)fortune) {
            World world = event.getWorld();
            List<BlockPos> list = BlockUtils.getAdjacentPosList((IBlockAccess)world, event.getPos(), pos -> !world.func_175623_d(pos));
            if (list.isEmpty()) {
                return;
            }
            BlockPos posToBreak = list.get(Utils.random.nextInt(list.size()));
            if (EventUtils.canHarvest(toolStack, world.func_180495_p(posToBreak))) {
                world.func_175655_b(posToBreak, true);
            }
            for (int i = 0; i < 10; ++i) {
                this.spawnParticle(world, posToBreak, 1.5f, true, 5, 0.0, 0.0, 0.0);
            }
            world.func_184133_a(null, posToBreak, SoundEvents.field_187619_bk, SoundCategory.BLOCKS, 2.0f, 1.5f);
        }
    }
}

