/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.advancement.CommonCriterionInstances;
import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SanguiniteToolEffect
extends BaseMetallurgyEffect {
    public SanguiniteToolEffect() {
        super(ModMetals.SANGUINITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.TOOL;
    }

    @Override
    public void rightClickHandler(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack toolStack = playerIn.func_184614_ca();
        CooldownTracker cooldowns = playerIn.func_184811_cZ();
        if (cooldowns.func_185143_a(toolStack.func_77973_b(), 0.0f) > 0.0f) {
            return;
        }
        playerIn.func_70097_a(DamageSource.field_82727_n, 6.0f);
        playerIn.func_184185_a(SoundEvents.field_187525_aO, 0.75f, 2.0f);
        int newDurability = Math.max(toolStack.func_77952_i() - 6, 0);
        toolStack.func_77964_b(newDurability);
        NBTTagCompound data = toolStack.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        data.func_74768_a("harvest_boost", 1);
        toolStack.func_77982_d(data);
        cooldowns.func_185145_a(toolStack.func_77973_b(), 320);
    }

    @SubscribeEvent
    public void triggerOverclockedTools(BlockEvent.HarvestDropsEvent event) {
        if (!this.canBeApplied((EntityLivingBase)event.getHarvester())) {
            return;
        }
        if (event.getHarvester() instanceof EntityPlayerMP) {
            ItemStack toolStack = event.getHarvester().func_184614_ca();
            CooldownTracker cooldown = event.getHarvester().func_184811_cZ();
            if (cooldown.func_185143_a(toolStack.func_77973_b(), 0.0f) > 0.0f) {
                ModAdvancements.Triggers.OVERCLOCKED_TOOLS.trigger((EntityPlayerMP)event.getHarvester(), new CommonCriterionInstances.AlwaysTrue(ModAdvancements.Triggers.OVERCLOCKED_TOOLS.func_192163_a()));
            }
        }
    }

    @SubscribeEvent
    public void boostHarvest(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!this.canBeApplied((EntityLivingBase)player)) {
            return;
        }
        ItemStack toolStack = player.func_184614_ca();
        NBTTagCompound toolData = toolStack.func_77978_p();
        if (player.func_184811_cZ().func_185143_a(toolStack.func_77973_b(), 0.0f) > 0.0f) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.75f);
            this.spawnParticle(player.field_70170_p, event.getPos(), 2.0f, true, 4, Math.random() * 0.5 - 0.25, Math.random() * 0.5 - 0.25, Math.random() * 0.5 - 0.25);
        } else if (toolData != null) {
            toolData.func_74768_a("harvest_boost", 0);
        }
    }
}

