/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import it.hurts.metallurgy_reforged.util.WorldUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class InolashiteToolEffect
extends BaseMetallurgyEffect {
    public InolashiteToolEffect() {
        super(ModMetals.INOLASHITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.TOOL;
    }

    @Override
    public void rightClickHandler(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (!this.canBeApplied((EntityLivingBase)player)) {
            return;
        }
        int range = 6;
        ItemStack tool = player.func_184586_b(hand);
        Vec3d eyePosition = player.func_174824_e(1.0f);
        Vec3d scaledLookVec = player.func_70040_Z().func_186678_a((double)range);
        Vec3d targetPos = eyePosition.func_178787_e(scaledLookVec);
        Iterator<BlockPos> posIt = WorldUtils.getAllColliding(eyePosition, targetPos).iterator();
        Iterator<Object> downPosIt = Collections.emptyIterator();
        if (player.field_70125_A > -60.0f && player.field_70125_A < 60.0f) {
            downPosIt = WorldUtils.getAllColliding(eyePosition.func_72441_c(0.0, -1.0, 0.0), targetPos.func_72441_c(0.0, -1.0, 0.0)).iterator();
        }
        EnumFacing facePointed = EnumFacing.func_176737_a((float)((float)scaledLookVec.field_72450_a), (float)((float)scaledLookVec.field_72448_b), (float)((float)scaledLookVec.field_72449_c)).func_176734_d();
        BlockPos assertivePos = null;
        while (posIt.hasNext() || downPosIt.hasNext()) {
            BlockPos pos;
            if (posIt.hasNext() && !world.func_175623_d(pos = posIt.next())) {
                if (EventUtils.canHarvest(tool, world.func_180495_p(pos))) {
                    world.func_175655_b(pos, true);
                    tool.func_77972_a(1, (EntityLivingBase)player);
                } else {
                    assertivePos = pos;
                    break;
                }
            }
            if (!downPosIt.hasNext() || world.func_175623_d(pos = (BlockPos)downPosIt.next())) continue;
            if (EventUtils.canHarvest(tool, world.func_180495_p(pos))) {
                world.func_175655_b(pos, true);
                tool.func_77972_a(1, (EntityLivingBase)player);
                continue;
            }
            assertivePos = pos;
            break;
        }
        if (assertivePos != null) {
            this.teleport(player, (double)assertivePos.func_177958_n() + 0.5 + (double)facePointed.func_82601_c(), assertivePos.func_177956_o() + facePointed.func_96559_d(), (double)assertivePos.func_177952_p() + 0.5 + (double)facePointed.func_82599_e());
        } else {
            this.teleport(player, player.field_70165_t + player.func_70040_Z().field_72450_a * (double)range, player.field_70163_u + player.func_70040_Z().field_72448_b * (double)range + 1.0, player.field_70161_v + player.func_70040_Z().field_72449_c * (double)range);
        }
        player.func_184609_a(hand);
        world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.func_184811_cZ().func_185145_a(tool.func_77973_b(), 200);
        player.field_70172_ad = 20;
    }

    private void teleport(EntityPlayer player, double x, double y, double z) {
        Random random = new Random();
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = player.field_70165_t + (x - player.field_70165_t) * d6 + (random.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
            double d4 = player.field_70163_u + (y - player.field_70163_u) * d6 + random.nextDouble() * (double)player.field_70131_O;
            double d5 = player.field_70161_v + (z - player.field_70161_v) * d6 + (random.nextDouble() - 0.5) * (double)player.field_70130_N * 2.0;
            player.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        player.func_70634_a(x, y, z);
    }
}

