/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import com.google.common.collect.Sets;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IgnatiusToolEffect
extends BaseMetallurgyEffect {
    public IgnatiusToolEffect() {
        super(ModMetals.IGNATIUS);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.TOOL;
    }

    @SubscribeEvent
    public void onBlockHarvested(BlockEvent.HarvestDropsEvent event) {
        boolean hadEffect = false;
        if (event.getHarvester() != null && this.canBeApplied((EntityLivingBase)event.getHarvester())) {
            hadEffect = this.dropSmeltedItems(event.getDrops(), event.getFortuneLevel());
        }
        if (hadEffect) {
            for (int i = 0; i < 10; ++i) {
                float f1 = Utils.random.nextFloat() / 16.0f - 0.03125f;
                float f2 = Utils.random.nextFloat() / 16.0f - 0.03125f;
                this.spawnParticle(event.getWorld(), event.getPos(), 2.0f, true, 3, f1, 0.02, f2);
            }
        }
    }

    public boolean dropSmeltedItems(List<ItemStack> drops, int fortune) {
        float fortuneLevelChance = (float)(fortune + 1) / 4.0f;
        HashSet newDrops = Sets.newHashSet();
        if (Math.random() < (double)fortuneLevelChance) {
            for (ItemStack drop : drops) {
                ItemStack smeltedItem = FurnaceRecipes.func_77602_a().func_151395_a(drop);
                smeltedItem.func_190920_e(drop.func_190916_E());
                newDrops.add(smeltedItem.func_190926_b() ? drop : smeltedItem);
            }
            drops.clear();
            drops.addAll(newDrops);
            return true;
        }
        return false;
    }
}

