/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.advancement.CommonCriterionInstances;
import it.hurts.metallurgy_reforged.advancement.ModAdvancements;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ElectrumToolEffect
extends BaseMetallurgyEffect {
    public ElectrumToolEffect() {
        super(ModMetals.ELECTRUM);
        IItemPropertyGetter condition = (stack, worldIn, entityIn) -> stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("voltage_control") ? 1.0f : 0.0f;
        this.setupModelOverrides(condition);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.TOOL;
    }

    @Override
    public void rightClickHandler(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        ItemStack toolStack = playerIn.func_184586_b(handIn);
        NBTTagCompound toolData = toolStack.func_77978_p();
        if (toolData == null) {
            toolData = new NBTTagCompound();
        }
        boolean newState = !toolData.func_74767_n("voltage_control");
        toolData.func_74757_a("voltage_control", newState);
        toolData.func_74768_a("harvest_boost", newState ? 1 : 0);
        if (worldIn.field_72995_K) {
            worldIn.func_184134_a(playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, newState ? 1.0f : 0.5f, false);
        }
        toolStack.func_77982_d(toolData);
        super.rightClickHandler(worldIn, playerIn, handIn);
    }

    @SubscribeEvent
    public void increaseHarvestLevel(BlockEvent.BreakEvent event) {
        if (!this.canBeApplied((EntityLivingBase)event.getPlayer())) {
            return;
        }
        ItemStack toolStack = event.getPlayer().func_184614_ca();
        if (toolStack.func_77978_p() != null && toolStack.func_77978_p().func_74767_n("voltage_control")) {
            toolStack.func_77964_b(toolStack.func_77952_i() + 4);
            if (event.getPlayer() instanceof EntityPlayerMP) {
                ModAdvancements.Triggers.OVERCLOCKED_TOOLS.trigger((EntityPlayerMP)event.getPlayer(), new CommonCriterionInstances.AlwaysTrue(ModAdvancements.Triggers.OVERCLOCKED_TOOLS.func_192163_a()));
            }
        }
    }

    @SubscribeEvent
    public void increaseBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!this.canBeApplied(event.getEntityLiving())) {
            return;
        }
        ItemStack toolStack = event.getEntityLiving().func_184614_ca();
        if (toolStack.func_77978_p() != null && toolStack.func_77978_p().func_74767_n("voltage_control")) {
            event.setNewSpeed(event.getOriginalSpeed() * 4.0f);
        }
    }
}

