/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CelenegilToolEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public CelenegilToolEffect() {
        super(ModMetals.CELENEGIL);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.TOOL;
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!this.canBeApplied((EntityLivingBase)player)) {
            return;
        }
        ExtraFilledDataBundle data = ((PlayerEffectData)player.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null)).celenegilToolBundle;
        int brokenBlocks = data.getExtraInt("broken_blocks");
        if (brokenBlocks >= 5) {
            if (brokenBlocks >= 60) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 30, 2));
            } else if (brokenBlocks >= 15) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 30, 1));
            } else {
                player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 30, 0));
            }
            ItemStack tool = player.func_184614_ca();
            data.setExtra("durability", tool.func_77952_i());
            data.setEffectStack(tool, player);
            data.setExtra("prev_broken_blocks", brokenBlocks);
        } else {
            event.getWorld().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187511_aA, SoundCategory.PLAYERS, 0.75f, 0.75f + (float)(brokenBlocks + 1) / 5.0f);
        }
        data.setExtra("inactive", false);
        data.setExtra("broken_blocks", brokenBlocks + 1);
    }

    @Override
    public void onStep(World world, EntityPlayer player, ItemStack effectStack, int maxSteps, int step) {
        ExtraFilledDataBundle data = (ExtraFilledDataBundle)this.getBundle(player, this.metal, this.getCategory());
        boolean inactive = data.getExtraBool("inactive");
        if (step == 1) {
            data.setExtra("inactive", true);
        }
        if (step == 3 && inactive) {
            data.setExtra("broken_blocks", 0);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187745_eA, SoundCategory.PLAYERS, 0.75f, 0.75f);
            int oldDurability = data.getExtraInt("durability");
            if (oldDurability != effectStack.func_77952_i()) {
                effectStack.func_77964_b(oldDurability);
            }
        }
    }
}

