/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.tool;

import it.hurts.metallurgy_reforged.capabilities.effect.BlockInfoDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CarmotToolEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public CarmotToolEffect() {
        super(ModMetals.CARMOT);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.TOOL;
    }

    @SubscribeEvent
    public void harvestBlocks(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!this.canBeApplied((EntityLivingBase)player)) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            if (!event.getState().func_177230_c().canHarvestBlock((IBlockAccess)event.getWorld(), event.getPos(), player)) {
                return;
            }
            if (EventUtils.canHarvest(player.func_184614_ca(), event.getState())) {
                BlockInfoDataBundle effectBundle = (BlockInfoDataBundle)this.getBundle(player, this.metal, this.getCategory());
                if (effectBundle.isEffectInProgress()) {
                    event.setCanceled(true);
                    return;
                }
                effectBundle.setBlockInfo(event.getPos(), event.getState());
                effectBundle.setEffectStack(player.func_184614_ca(), player);
                effectBundle.incrementStep(player);
                int cooldown = (effectBundle.getMaxSteps() - Math.max(0, event.getState().func_177230_c().getHarvestLevel(event.getState()) - 2) + 3) * effectBundle.stepTickDelay;
                player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), cooldown);
            }
        }
    }

    @Override
    public void onStep(World world, EntityPlayer player, ItemStack effectStack, int maxSteps, int step) {
        BlockInfoDataBundle blockBundle = (BlockInfoDataBundle)this.getBundle(player, this.metal, this.getCategory());
        BlockPos pos = blockBundle.getPos();
        IBlockState state = blockBundle.getState();
        if (pos == null || state == null) {
            return;
        }
        if (step > maxSteps - Math.max(0, state.func_177230_c().getHarvestLevel(state) - 2) || effectStack.func_190926_b()) {
            blockBundle.resetProgress(player);
            return;
        }
        if (!world.field_72995_K) {
            for (int x = -step - 1; x < step + 1; ++x) {
                for (int y = -step - 1; y < step + 1; ++y) {
                    for (int z = -step - 1; z < step + 1; ++z) {
                        BlockPos blockPos = pos.func_177982_a(x, y, z);
                        IBlockState blockState = world.func_180495_p(blockPos);
                        if (Math.ceil(blockPos.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) != (double)step || !Block.func_149680_a((Block)blockState.func_177230_c(), (Block)state.func_177230_c())) continue;
                        world.func_175655_b(blockPos, true);
                        effectStack.func_77972_a(1, (EntityLivingBase)player);
                    }
                }
            }
            float pitch = (float)(8 - step) / 6.0f;
            world.func_184133_a(null, pos, SoundEvents.field_187603_D, SoundCategory.BLOCKS, 1.5f, pitch);
        }
    }
}

