/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.pickaxe;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.handler.OreDictHandler;
import it.hurts.metallurgy_reforged.material.Metal;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.sound.ModSounds;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OureclasePickaxeEffect
extends BaseMetallurgyEffect {
    public OureclasePickaxeEffect() {
        super(ModMetals.OURECLASE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.PICKAXE;
    }

    @SubscribeEvent
    public void harvestDusts(BlockEvent.HarvestDropsEvent event) {
        if (!this.canBeApplied((EntityLivingBase)event.getHarvester())) {
            return;
        }
        LinkedHashSet<ItemStack> dusts = new LinkedHashSet<ItemStack>();
        Iterator dropIt = event.getDrops().iterator();
        while (dropIt.hasNext()) {
            ItemStack drop = (ItemStack)dropIt.next();
            if (!OreDictHandler.containsPrefix(drop, "ore")) {
                return;
            }
            Metal metal = ItemUtils.getMetalFromOreDictStack(drop);
            if (metal == null) continue;
            dropIt.remove();
            dusts.add(new ItemStack((Item)metal.getDust()));
        }
        if (!dusts.isEmpty()) {
            event.getDrops().addAll(dusts);
            event.getWorld().func_184133_a(null, event.getPos(), ModSounds.CRUSHER_IMPACT, SoundCategory.BLOCKS, 0.8f, 1.2f);
            for (int i = 0; i < 5; ++i) {
                this.spawnParticle(event.getWorld(), event.getPos(), 3.0f, false, 5, 0.0, 0.0, 0.0);
            }
        }
    }
}

