/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.pickaxe;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class DamascusSteelPickaxeEffect
extends BaseMetallurgyEffect {
    public DamascusSteelPickaxeEffect() {
        super(ModMetals.DAMASCUS_STEEL);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.PICKAXE;
    }

    @SubscribeEvent
    public void onOreBroken(BlockEvent.BreakEvent event) {
        if (!this.canBeApplied((EntityLivingBase)event.getPlayer())) {
            return;
        }
        if (Utils.random.nextBoolean()) {
            Block ore = event.getState().func_177230_c();
            ItemStack oreStack = new ItemStack(ore);
            if (oreStack.func_190926_b()) {
                return;
            }
            boolean isOre = Arrays.stream(OreDictionary.getOreIDs((ItemStack)oreStack)).mapToObj(OreDictionary::getOreName).anyMatch(oreName -> oreName.startsWith("ore"));
            if (isOre) {
                event.setExpToDrop(event.getExpToDrop() + ore.getHarvestLevel(event.getState()) + 1);
            }
        }
    }
}

