/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.pickaxe;

import it.hurts.metallurgy_reforged.block.BlockOre;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.item.ItemBlockOre;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AngmallenPickaxeEffect
extends BaseMetallurgyEffect {
    public AngmallenPickaxeEffect() {
        super(ModMetals.ANGMALLEN);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.PICKAXE;
    }

    @SubscribeEvent
    public void transmuteOre(BlockEvent.HarvestDropsEvent event) {
        if (!this.canBeApplied((EntityLivingBase)event.getHarvester())) {
            return;
        }
        Block block = event.getState().func_177230_c();
        if (!event.getWorld().field_72995_K && block instanceof BlockOre && Utils.random.nextInt(10) < 3 + event.getFortuneLevel() * 3) {
            event.getDrops().clear();
            ItemStack stack = AngmallenPickaxeEffect.getRandomOreStack((BlockOre)event.getState().func_177230_c(), hLevel -> {
                int blockHL = block.getHarvestLevel(event.getState());
                return hLevel >= blockHL - 1 && hLevel <= blockHL + 1;
            });
            ItemBlockOre.setLocked(stack, true);
            event.getHarvester().func_184614_ca().func_77972_a(1, (EntityLivingBase)event.getHarvester());
            event.getDrops().add(stack);
            event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 20; ++i) {
                this.spawnParticle(event.getWorld(), event.getPos(), 1.3f, true, 5, 0.0, 0.2, 0.0);
            }
        }
    }

    static ItemStack getRandomOreStack(BlockOre ore, IntPredicate harvestLevelCondition) {
        List oresDropList = ModMetals.metalMap.values().stream().filter(mettle -> {
            if (mettle.isAlloy() || ore == mettle.getOre()) {
                return false;
            }
            int level = mettle.getStats().getOreHarvest();
            return harvestLevelCondition.test(level);
        }).map(mettle -> new ItemStack((Block)mettle.getOre())).collect(Collectors.toList());
        return (ItemStack)oresDropList.get(Utils.random.nextInt(oresDropList.size()));
    }
}

