/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.hoe;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.Utils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MidasiumHoeEffect
extends BaseMetallurgyEffect {
    public MidasiumHoeEffect() {
        super(ModMetals.MIDASIUM);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.HOE;
    }

    @SubscribeEvent
    public void hoeInteractBreakCrop(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block crop = state.func_177230_c();
        if (this.canBeApplied((EntityLivingBase)player) && crop instanceof BlockCrops) {
            crop.removedByPlayer(state, world, event.getPos(), player, true);
            TileEntity tileEntity = world.func_175625_s(event.getPos());
            world.func_184133_a(null, event.getPos(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            crop.func_180657_a(world, player, event.getPos(), state, tileEntity, event.getItemStack());
        }
    }

    @SubscribeEvent
    public void hoeHarvest(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        EntityPlayer player = event.getHarvester();
        if (this.canBeApplied((EntityLivingBase)player) && state.func_177230_c() instanceof BlockCrops) {
            float chance = 0.35f + (float)event.getFortuneLevel() * 0.15f;
            if (Math.random() <= (double)chance) {
                BlockCrops crops = (BlockCrops)state.func_177230_c();
                List drops = event.getDrops();
                ItemStack seeds = crops.func_185473_a(player.field_70170_p, event.getPos(), state);
                ItemStack hoe = player.func_184614_ca();
                hoe.func_77964_b(hoe.func_77952_i() + 1);
                List goldDrops = drops.stream().map(stack -> new ItemStack(ItemStack.func_179545_c((ItemStack)stack, (ItemStack)seeds) ? Items.field_151074_bl : Items.field_151043_k, stack.func_190916_E())).collect(Collectors.toList());
                drops.clear();
                drops.addAll(goldDrops);
                for (int i = 0; i < 10; ++i) {
                    double d1 = (Utils.random.nextDouble() - 0.5) * 0.15;
                    double d2 = (Utils.random.nextDouble() - 0.5) * 0.15;
                    double d3 = (Utils.random.nextDouble() - 0.5) * 0.15;
                    this.spawnParticle(event.getWorld(), event.getPos(), 2.0f, true, 3, d1, d2, d3);
                }
                event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_193808_ex, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

