/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import com.google.common.collect.Sets;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.IntBiFunction;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VyroxeresArmorEffect
extends BaseMetallurgyEffect {
    private static final UUID PROTECTION_MODIFIER_UUID = UUID.fromString("91AEAB56-376B-1298-935B-2F7F68070333");
    private final IntBiFunction<AttributeModifier> generateProtectionMod = (stacks, level) -> new AttributeModifier(PROTECTION_MODIFIER_UUID, "Vyroxeres_Protection_Mod", (double)stacks * (level <= 2 ? (double)level : (double)level - 0.5), 0);

    public VyroxeresArmorEffect() {
        super(ModMetals.VYROXERES);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void potionProtectionBuff(PotionEvent event) {
        if (event instanceof PotionEvent.PotionApplicableEvent) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        IAttributeInstance userArmor = entity.func_110148_a(SharedMonsterAttributes.field_188791_g);
        int level = this.getLevel(entity);
        if (level == 0) {
            userArmor.func_188479_b(PROTECTION_MODIFIER_UUID);
            return;
        }
        PotionEffect eventEffect = event.getPotionEffect();
        int stacks = 0;
        if (event instanceof PotionEvent.PotionAddedEvent) {
            PotionEffect oldPotion = ((PotionEvent.PotionAddedEvent)event).getOldPotionEffect();
            assert (eventEffect != null);
            if (oldPotion == null || oldPotion.func_76458_c() != eventEffect.func_76458_c()) {
                userArmor.func_188479_b(PROTECTION_MODIFIER_UUID);
                HashSet currentPotions = Sets.newHashSet((Iterable)entity.func_70651_bq());
                currentPotions.add(eventEffect);
                if (oldPotion != null) {
                    currentPotions.remove(oldPotion);
                }
                stacks = this.calculatePotionStacks(currentPotions);
            }
        } else if ((event instanceof PotionEvent.PotionRemoveEvent || event instanceof PotionEvent.PotionExpiryEvent) && eventEffect != null) {
            userArmor.func_188479_b(PROTECTION_MODIFIER_UUID);
            HashSet effects = Sets.newHashSet((Iterable)entity.func_70651_bq());
            effects.remove(eventEffect);
            stacks = this.calculatePotionStacks(effects);
        }
        if (stacks > 0) {
            AttributeModifier protMod = this.generateProtectionMod.apply(stacks, level);
            userArmor.func_111121_a(protMod);
            System.out.println(protMod.func_111164_d());
        }
    }

    private int calculatePotionStacks(Set<PotionEffect> effects) {
        return effects.stream().reduce(0, (stackHeap, effect) -> stackHeap + (effect.func_76458_c() + 1), Integer::sum);
    }

    @SubscribeEvent
    public void equipmentUpdated(LivingEquipmentChangeEvent event) {
        if (event.getSlot().func_188453_a() == EntityEquipmentSlot.Type.ARMOR && !this.canBeApplied(event.getEntityLiving())) {
            event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(PROTECTION_MODIFIER_UUID);
        }
    }
}

