/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VulcaniteArmorEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    private static final int RADIUS = 5;

    public VulcaniteArmorEffect() {
        super(ModMetals.VULCANITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        int level = this.getLevel(event.getEntityLiving());
        if (level == 0) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer entity = (EntityPlayer)event.getEntityLiving();
            ExtraFilledDataBundle data = this.getEffectCapability((EntityPlayer)entity).vulcaniteArmorBundle;
            int hits = data.getExtraInt("hits");
            if (hits > 4) {
                entity.field_70170_p.func_72839_b((Entity)entity, new AxisAlignedBB(entity.field_70165_t - 5.0, entity.field_70163_u - 1.0, entity.field_70161_v - 5.0, entity.field_70165_t + 5.0, entity.field_70163_u + 1.0, entity.field_70161_v + 5.0)).forEach(enemy -> {
                    entity.field_70170_p.func_72885_a((Entity)entity, enemy.field_70165_t, enemy.field_70163_u + 1.1, enemy.field_70161_v, 0.7f + (float)level * 0.1f, level > 2, false);
                    if (level > 2) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200));
                    }
                    for (int i = 0; i < 10; ++i) {
                        this.spawnParticle((Entity)enemy, 2.5f, true, 3);
                    }
                });
                data.setExtra("hits", 0);
            } else {
                data.setExtra("hits", hits + 1);
                data.setExtra("inactive", false);
            }
        }
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        ExtraFilledDataBundle bundle = this.getEffectCapability((EntityPlayer)entity).vulcaniteArmorBundle;
        if (step == 1 && !bundle.getExtraBool("inactive")) {
            bundle.setExtra("inactive", true);
        }
        if (step == 3 && bundle.getExtraBool("inactive")) {
            bundle.setExtra("hits", 0);
        }
    }
}

