/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.EventUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ShadowSteelArmorEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("91AEAB56-376B-1298-935B-2F7F68070635");

    public ShadowSteelArmorEffect() {
        super(ModMetals.SHADOW_STEEL);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void triggerEclipse(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int level = this.getLevel(entity);
        if (level == 0) {
            return;
        }
        float darknessLevel = EventUtils.getDarknessLevel((Entity)entity, 1.0f);
        if (entity instanceof EntityPlayer) {
            float cooldown = ((EntityPlayer)entity).func_184811_cZ().func_185143_a(this.getArmorRepr(entity).func_77973_b(), 0.0f);
            if (cooldown > 0.0f) {
                return;
            }
            ExtraFilledDataBundle bundle = this.getEffectCapability((EntityPlayer)((EntityPlayer)entity)).shadowSteelArmorBundle;
            boolean darkEffectTookPlace = bundle.getExtraBool("dark");
            if (darkEffectTookPlace && bundle.isEffectInProgress()) {
                event.setCanceled(true);
                return;
            }
        } else if (entity.func_70644_a(MobEffects.field_76424_c)) {
            event.setCanceled(true);
            entity.func_184589_d(MobEffects.field_76424_c);
        }
        if (darknessLevel > 0.5f) {
            if (entity instanceof EntityPlayer) {
                AttributeModifier modifier = new AttributeModifier(SPEED_MODIFIER_UUID, "SHADOW_STEEL_Armor_Movement_Buff", (double)0.2f * (double)level, 2);
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(modifier);
                EntityPlayer player = (EntityPlayer)entity;
                ExtraFilledDataBundle bundle = (ExtraFilledDataBundle)this.getBundle(player, this.metal, this.getCategory());
                bundle.incrementStep(player);
                bundle.setExtra("dark", true);
            } else if (entity.func_70681_au().nextBoolean()) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 60, level - 1));
            }
        } else {
            List nearbyEntities = entity.field_70170_p.func_175674_a((Entity)entity, new AxisAlignedBB(entity.field_70165_t - 3.0, entity.field_70163_u - 1.0, entity.field_70161_v - 3.0, entity.field_70165_t + 3.0, entity.field_70163_u + 1.0, entity.field_70161_v + 3.0), ent -> ent instanceof EntityLivingBase);
            nearbyEntities.forEach(nearby -> {
                nearby.func_70097_a(DamageSource.field_76372_a, (float)(3 * level));
                ((EntityLivingBase)nearby).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20 + 10 * level));
            });
        }
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        if (step == maxSteps) {
            if (this.getEffectCapability((EntityPlayer)entity).shadowSteelArmorBundle.getExtraBool("dark")) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(SPEED_MODIFIER_UUID);
            }
            assert (this.metal.getArmorSet() != null);
            for (ItemArmorBase armorP : this.metal.getArmorSet()) {
                entity.func_184811_cZ().func_185145_a((Item)armorP, 20 * (30 - 5 * this.getLevel((EntityLivingBase)entity)));
            }
        }
    }
}

