/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.Metallurgy;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.client.PacketSanguiniteEntityState;
import it.hurts.metallurgy_reforged.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SanguiniteArmorEffect
extends BaseMetallurgyEffect {
    private final Method getExperiencePoints = ObfuscationReflectionHelper.findMethod(EntityLivingBase.class, (String)"func_70693_a", Integer.TYPE, (Class[])new Class[]{EntityPlayer.class});
    private final Method dropLoot = ObfuscationReflectionHelper.findMethod(EntityLivingBase.class, (String)"func_184610_a", Void.TYPE, (Class[])new Class[]{Boolean.TYPE, Integer.TYPE, DamageSource.class});
    private static final float[] OVERLAY = new float[]{0.39215687f, 0.09803922f, 0.09803922f};

    public SanguiniteArmorEffect() {
        super(ModMetals.SANGUINITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    private void dropXPAndItems(EntityLivingBase killedEntity, EntityLivingBase killer, DamageSource source) throws InvocationTargetException, IllegalAccessException {
        int xpSlice;
        for (int xp = ((Integer)this.getExperiencePoints.invoke((Object)killedEntity, killer)).intValue(); xp > 0; xp -= xpSlice) {
            xpSlice = EntityXPOrb.func_70527_a((int)xp);
            killer.field_70170_p.func_72838_d((Entity)new EntityXPOrb(killer.field_70170_p, killedEntity.field_70165_t, killedEntity.field_70163_u, killedEntity.field_70161_v, xpSlice));
        }
    }

    @SubscribeEvent
    public void dropCorpseLoot(LivingDeathEvent event) {
        if (event.getEntityLiving().getEntityData().func_74762_e("corpse_state") == 2 && event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int looting = ForgeHooks.getLootingLevel((Entity)event.getEntityLiving(), (Entity)event.getSource().func_76346_g(), (DamageSource)event.getSource());
            try {
                this.dropLoot.invoke((Object)event.getEntityLiving(), true, looting, event.getSource());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Metallurgy.logger.error("Error while dropping corpse Drops (Necromastery Effect Error)");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void updateCorpseStates(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int corpseState = entity.getEntityData().func_74762_e("corpse_state");
        if (corpseState == 2) {
            return;
        }
        if (corpseState == 0) {
            if (entity.field_70725_aQ == 16 && entity.func_94060_bK() instanceof EntityPlayer) {
                int level = this.getLevel(entity.func_94060_bK());
                if (level == 0) {
                    return;
                }
                entity.getEntityData().func_74768_a("corpse_state", 1);
                PacketSanguiniteEntityState packet = new PacketSanguiniteEntityState(entity.func_145782_y(), 1);
                PacketManager.network.sendToAllTracking((IMessage)packet, (Entity)entity);
                entity.field_70173_aa = 0;
                try {
                    this.dropXPAndItems(entity, entity.func_94060_bK(), entity.func_189748_bU());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Metallurgy.logger.error("Error while dropping pre-corpse Experience (Necromastery Effect Error)");
                    e.printStackTrace();
                }
            }
        } else if (entity.field_70173_aa < 20) {
            entity.field_70725_aQ = 18;
        } else if (entity.field_70725_aQ >= 0) {
            entity.field_70725_aQ -= 2;
        } else {
            entity.func_70606_j(entity.func_110138_aP() * 0.4f);
            entity.getEntityData().func_74768_a("corpse_state", 2);
            entity.field_70725_aQ = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderLivingCorpse(EntityLivingBase entity, double x, double y, double z) {
        int corpseState = entity.getEntityData().func_74762_e("corpse_state");
        if (corpseState < 1) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)OVERLAY[0], (float)OVERLAY[1], (float)OVERLAY[2], (float)1.0f);
        double deltaX = Utils.random.nextGaussian() * 0.01;
        double deltaZ = Utils.random.nextGaussian() * 0.01;
        GlStateManager.func_179137_b((double)(x + deltaX), (double)y, (double)(z + deltaZ));
        GlStateManager.func_179121_F();
    }
}

