/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class QuicksilverArmorEffect
extends BaseMetallurgyEffect {
    private static final UUID SPEED_UUID = UUID.fromString("91AEAB56-376B-1298-935B-2F7F68070635");
    private final BiPredicate<Integer, IBlockState> canWalkOnLava = (level, state) -> state.func_185904_a() == Material.field_151587_i && level > 2;

    public QuicksilverArmorEffect() {
        super(ModMetals.QUICKSILVER);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void sprintThrottling(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END || !this.canBeApplied((EntityLivingBase)event.player)) {
            return;
        }
        PlayerEffectData capa = (PlayerEffectData)event.player.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null);
        if (capa == null) {
            return;
        }
        IAttributeInstance attributeInstance = event.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        float level = this.getLevel((EntityLivingBase)event.player);
        float maxStep = Math.round(Math.max(8.0f * (1.0f - level / 4.0f), 0.5f) * 20.0f);
        float speedMultiplier = (2.5f * level * level + 2.5f * level) * 0.01f;
        if (event.player.func_70051_ag()) {
            if ((float)capa.quicksilverTick < maxStep) {
                ++capa.quicksilverTick;
                AttributeModifier attributemodifier = new AttributeModifier(SPEED_UUID, this.getName(), (double)(speedMultiplier *= Math.min((float)capa.quicksilverTick / maxStep, 1.0f)), 2);
                attributeInstance.func_188479_b(SPEED_UUID);
                attributeInstance.func_111121_a(attributemodifier);
            } else {
                event.player.field_70138_W = 1.0f;
            }
        } else if (capa.quicksilverTick > 0) {
            capa.quicksilverTick = 0;
            attributeInstance.func_188479_b(SPEED_UUID);
            event.player.field_70138_W = 0.6f;
        }
    }

    @SubscribeEvent
    public void walkOnLiquid(GetCollisionBoxesEvent event) {
        World world = event.getWorld();
        Entity entity = event.getEntity();
        AxisAlignedBB playerBB = event.getAabb();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        int level = this.getLevel((EntityLivingBase)entity);
        if (level == 0) {
            return;
        }
        PlayerEffectData capa = (PlayerEffectData)entity.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null);
        if (capa == null) {
            return;
        }
        float maxStep = Math.round(Math.max(8.0f * (1.0f - (float)level / 4.0f), 0.5f) * 20.0f);
        if ((float)capa.quicksilverTick < maxStep) {
            return;
        }
        BlockPos.PooledMutableBlockPos minPos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(playerBB.field_72340_a + 0.001), (double)(playerBB.field_72338_b + 0.001), (double)(playerBB.field_72339_c + 0.001));
        BlockPos.PooledMutableBlockPos maxPos = BlockPos.PooledMutableBlockPos.func_185345_c((double)(playerBB.field_72336_d - 0.001), (double)(playerBB.field_72337_e - 0.001), (double)(playerBB.field_72334_f - 0.001));
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (world.func_175707_a((BlockPos)minPos, (BlockPos)maxPos)) {
            for (int x = minPos.func_177958_n(); x <= maxPos.func_177958_n(); ++x) {
                for (int y = minPos.func_177956_o(); y <= maxPos.func_177956_o(); ++y) {
                    for (int z = minPos.func_177952_p(); z <= maxPos.func_177952_p(); ++z) {
                        pos.func_181079_c(x, y, z);
                        IBlockState state = world.func_180495_p((BlockPos)pos);
                        if (state.func_185904_a() != Material.field_151586_h && !this.canWalkOnLava.test(level, state)) continue;
                        AxisAlignedBB fluidBox = Block.field_185505_j.func_186670_a((BlockPos)pos);
                        event.getCollisionBoxesList().add(fluidBox);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void cancelLavaDamage(LivingAttackEvent event) {
        int level = this.getLevel(event.getEntityLiving());
        if (event.getSource() != DamageSource.field_76372_a || level < 3) {
            return;
        }
        PlayerEffectData capa = (PlayerEffectData)event.getEntityLiving().getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null);
        if (capa == null) {
            return;
        }
        int maxTicks = Math.round(Math.max(8.0f * (1.0f - (float)level / 4.0f), 0.5f) * 20.0f);
        if (capa.quicksilverTick == maxTicks) {
            event.setCanceled(true);
        }
    }
}

