/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import it.hurts.metallurgy_reforged.util.WorldUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PrometheumArmorEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public PrometheumArmorEffect() {
        super(ModMetals.PROMETHEUM);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void boneMealNearbyFlora(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.canBeApplied((EntityLivingBase)event.player) || this.getEffectCapability(event.player) == null) {
            return;
        }
        ExtraFilledDataBundle bundle = this.getEffectCapability((EntityPlayer)event.player).prometheumArmorBundle;
        if (!bundle.isEffectInProgress() && event.player.func_70093_af() && event.player.func_184811_cZ().func_185143_a(this.getArmorRepr((EntityLivingBase)event.player).func_77973_b(), 0.0f) == 0.0f) {
            bundle.setExtra("sneaking", event.player.func_70093_af());
            bundle.incrementStep(event.player);
        }
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        ExtraFilledDataBundle bundle = this.getEffectCapability((EntityPlayer)entity).prometheumArmorBundle;
        boolean sneaking = bundle.getExtraBool("sneaking");
        if (step % 2 != 0) {
            bundle.setExtra("sneaking", entity.func_70093_af());
        } else if (entity.func_70093_af() != sneaking) {
            List<BlockPos> growables = WorldUtils.getBlocksWithinRadius(entity.func_180425_c(), 3.0f, 1.0f, 3.0f, pos -> entity.field_70170_p.func_180495_p(pos).func_177230_c() instanceof IGrowable);
            Collections.shuffle(growables);
            AtomicBoolean grassWasBoneMealed = new AtomicBoolean(false);
            growables.forEach(pos -> {
                float chance = (float)this.getLevel((EntityLivingBase)entity) * 0.25f * 0.75f;
                if (Math.random() < (double)chance && (!grassWasBoneMealed.get() || world.func_180495_p(pos).func_177230_c() != Blocks.field_150349_c)) {
                    if (ItemDye.func_179234_a((ItemStack)ItemStack.field_190927_a, (World)entity.field_70170_p, (BlockPos)pos)) {
                        entity.field_70170_p.func_175718_b(2005, pos, 0);
                        entity.func_184193_aE().forEach(armorStack -> {
                            if (ItemUtils.isMadeOfMetal(this.metal, armorStack.func_77973_b(), new Class[0]) || TartariteEffect.getParagonMetal(armorStack) == this.metal) {
                                armorStack.func_77972_a(2, (EntityLivingBase)entity);
                            }
                        });
                    }
                    if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c) {
                        grassWasBoneMealed.set(true);
                    }
                }
            });
        }
        if (step == maxSteps) {
            assert (this.metal.getArmorSet() != null);
            for (ItemArmorBase armorItem : this.metal.getArmorSet()) {
                entity.func_184811_cZ().func_185145_a((Item)armorItem, 180);
            }
        }
    }
}

