/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import com.google.common.collect.ImmutableMap;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlatinumArmorEffect
extends BaseMetallurgyEffect {
    private final Map<Potion, Potion> potionPurificationMap = ImmutableMap.of((Object)MobEffects.field_76436_u, (Object)MobEffects.field_76428_l, (Object)MobEffects.field_76421_d, (Object)MobEffects.field_76424_c, (Object)MobEffects.field_76437_t, (Object)MobEffects.field_76420_g);

    public PlatinumArmorEffect() {
        super(ModMetals.PLATINUM);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void purifyEffects(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        float level = (float)this.getLevel(entity) / 2.0f;
        if (level == 0.0f) {
            return;
        }
        this.potionPurificationMap.forEach((badPotion, goodPotion) -> {
            PotionEffect potionEffect = entity.func_70660_b(badPotion);
            if (potionEffect != null) {
                int i;
                int newDuration = (int)(level * (float)potionEffect.func_76459_b());
                entity.func_184589_d(badPotion);
                entity.func_70690_d(new PotionEffect(goodPotion, newDuration, potionEffect.func_76458_c()));
                Vec3d halvedLookVec = entity.func_70040_Z().func_186678_a(0.5);
                for (i = 0; i < 2; ++i) {
                    this.spawnParticle(entity.field_70170_p, entity.field_70165_t + halvedLookVec.field_72450_a, entity.field_70163_u + (double)1.1f, entity.field_70161_v + halvedLookVec.field_72449_c, 1.0f, true, 5);
                }
                for (i = 0; i < 5; ++i) {
                    this.spawnParticle((Entity)entity, 1.0f, true, 5);
                }
            }
        });
    }
}

