/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OrichalcumArmorEffect
extends BaseMetallurgyEffect {
    public OrichalcumArmorEffect() {
        super(ModMetals.ORICHALCUM);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void onEntityKillEvent(LivingDeathEvent event) {
        Entity entity = event.getSource().func_76346_g();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)entity;
            int level = this.getLevel(attacker);
            if (level == 0) {
                return;
            }
            if (event.getEntityLiving() instanceof EntityLiving && ((EntityLiving)event.getEntityLiving()).func_70638_az() == attacker) {
                int radius = 2 + level * 3;
                AxisAlignedBB searchBox = new AxisAlignedBB(attacker.func_180425_c()).func_186662_g((double)radius);
                int totalMobs = entity.field_70170_p.func_175647_a(EntityLiving.class, searchBox, mob -> mob.func_70089_S() && mob != attacker && mob.func_70638_az() == attacker).size();
                if (totalMobs > 0) {
                    int amplifier = Math.min(totalMobs - 1, 5);
                    int buffTime = level * 3 * 20;
                    attacker.func_70690_d(new PotionEffect(MobEffects.field_76420_g, buffTime, amplifier));
                }
            }
        }
    }
}

