/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.config.EffectsRosterConfig;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.network.PacketManager;
import it.hurts.metallurgy_reforged.network.server.PacketKrikEditPlayerLevel;
import it.hurts.metallurgy_reforged.util.EventUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class KrikArmorEffect
extends BaseMetallurgyEffect {
    public KrikArmorEffect() {
        super(ModMetals.KRIK);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void livingUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (this.getLevel((EntityLivingBase)player) < 4) {
            return;
        }
        int STEP = 9;
        PlayerEffectData capability = (PlayerEffectData)player.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null);
        if (capability != null) {
            int level = capability.krikHeight;
            int maxLevel = KrikArmorEffect.getKrikMaxLevel(player);
            if (level <= maxLevel) {
                if (player.field_70163_u < (double)(level * 9)) {
                    player.field_70181_x = 0.4;
                } else if (Math.round(player.field_70163_u) == (long)level * 9L) {
                    player.field_70181_x = 0.0;
                }
            } else {
                capability.krikHeight = maxLevel;
            }
        }
    }

    @SubscribeEvent
    public void cancelFall(LivingFallEvent event) {
        if (this.getLevel(event.getEntityLiving()) == 4 && event.getEntityLiving() instanceof EntityPlayer) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void changeKrikLevel(EntityPlayer player, PlayerEffectData capability) {
        if (EventUtils.isWearingFullArmorSet((EntityLivingBase)player, ModMetals.KRIK) && EffectsRosterConfig.krikEffectArmor) {
            if (Keyboard.isKeyDown((int)200) && capability != null && capability.krikHeight < KrikArmorEffect.getKrikMaxLevel(player)) {
                PacketManager.network.sendToServer((IMessage)new PacketKrikEditPlayerLevel(true));
                ++capability.krikHeight;
            }
            if (Keyboard.isKeyDown((int)208) && capability != null && capability.krikHeight > 0) {
                PacketManager.network.sendToServer((IMessage)new PacketKrikEditPlayerLevel(false));
                --capability.krikHeight;
            }
        }
    }

    public static int getKrikMaxLevel(EntityPlayer player) {
        int count = 0;
        for (int i = 9; i < 36; ++i) {
            Slot k = new Slot((IInventory)player.field_71071_by, i, 0, 0);
            if (k.func_75216_d()) continue;
            ++count;
        }
        return count;
    }
}

