/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KalendriteArmorEffect
extends BaseMetallurgyEffect {
    public KalendriteArmorEffect() {
        super(ModMetals.KALENDRITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @SubscribeEvent
    public void registerDamageTimestamp(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!this.canBeApplied(entity)) {
            return;
        }
        ItemStack armorStack = this.getArmorRepr(entity);
        NBTTagCompound armorData = armorStack.func_77978_p();
        if (armorData != null && entity.func_70644_a(MobEffects.field_76428_l)) {
            entity.func_184589_d(MobEffects.field_76428_l);
        }
        if (armorData == null) {
            armorData = new NBTTagCompound();
        }
        armorData.func_74772_a("damage_timestamp", entity.field_70170_p.func_82737_E());
        armorStack.func_77982_d(armorData);
    }

    @SubscribeEvent
    public void regenHealth(LivingEvent.LivingUpdateEvent event) {
        int delay;
        long delta;
        EntityLivingBase entity = event.getEntityLiving();
        int level = this.getLevel(entity);
        if (level == 0 || entity.field_70173_aa % 4 != 0) {
            return;
        }
        NBTTagCompound armorData = this.getArmorRepr(entity).func_77978_p();
        if (armorData != null && armorData.func_74764_b("damage_timestamp") && (delta = entity.field_70170_p.func_82737_E() - armorData.func_74763_f("damage_timestamp")) >= (long)(delay = 20 << 5 - level) && (!entity.func_70644_a(MobEffects.field_76428_l) || entity.func_70660_b(MobEffects.field_76428_l).func_76459_b() <= 200)) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 410, level - 1));
        }
    }
}

