/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.EffectDataProvider;
import it.hurts.metallurgy_reforged.capabilities.effect.ExtraFilledDataBundle;
import it.hurts.metallurgy_reforged.capabilities.effect.PlayerEffectData;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import java.util.Queue;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class InolashiteArmorEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    public InolashiteArmorEffect() {
        super(ModMetals.INOLASHITE);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    private void addScrollQueue(WarpData newItem, Queue<WarpData> queue, int backtrackExtension) {
        while (!queue.isEmpty() && backtrackExtension * 4 <= queue.size()) {
            queue.poll();
        }
        queue.add(newItem);
    }

    @SubscribeEvent
    public void recallLoop(TickEvent.PlayerTickEvent event) {
        float cooldown;
        int backTrackExtension = this.getLevel((EntityLivingBase)event.player) * 2;
        if (event.phase != TickEvent.Phase.START || backTrackExtension == 0) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70173_aa % 5 == 0) {
            Queue<WarpData> warpQueue = ((PlayerEffectData)player.getCapability(EffectDataProvider.PLAYER_EFFECT_DATA_CAPABILITY, null)).inolashiteWarpData;
            WarpData data = new WarpData(player.func_180425_c(), player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e());
            this.addScrollQueue(data, warpQueue, backTrackExtension);
        }
        if ((cooldown = player.func_184811_cZ().func_185143_a(this.getArmorRepr((EntityLivingBase)player).func_77973_b(), 0.0f)) > 0.0f) {
            return;
        }
        if (player.func_70093_af() && player.field_70173_aa % 2 == 0 && !player.field_70170_p.field_72995_K) {
            for (double i = 0.0; i < Math.PI * 2; i += 0.3141592653589793) {
                this.spawnParticle(player.field_70170_p, player.field_70165_t + Math.sin(i), player.field_70163_u + 2.0, player.field_70161_v + Math.cos(i), 1.0f, true, 4);
            }
        }
    }

    @SubscribeEvent
    public void triggerWarp(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && this.canBeApplied(event.getEntityLiving()) && event.getEntityLiving().func_70093_af()) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (player.func_184811_cZ().func_185143_a(this.getArmorRepr(event.getEntityLiving()).func_77973_b(), 0.0f) > 0.0f) {
                return;
            }
            PlayerEffectData capability = this.getEffectCapability(player);
            if (!capability.inolashiteWarpData.isEmpty()) {
                capability.inolashiteArmorBundle.setExtras(capability.inolashiteWarpData.element().serializeNBT());
                capability.inolashiteArmorBundle.incrementStep(player);
            }
            int level = this.getLevel((EntityLivingBase)player);
            int cooldown = (int)(Math.pow(2.0, 7 - level) * 20.0);
            assert (this.metal.getArmorSet() != null);
            for (ItemArmorBase armor : this.metal.getArmorSet()) {
                player.func_184811_cZ().func_185145_a((Item)armor, cooldown);
            }
        }
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        WarpData data = new WarpData();
        data.deserializeNBT(((ExtraFilledDataBundle)this.getBundle(entity, this.metal, this.getCategory())).getExtras());
        if (!world.field_72995_K) {
            entity.func_70634_a((double)data.position.func_177958_n(), (double)data.position.func_177956_o() + 0.1, (double)data.position.func_177952_p());
        }
        entity.func_70606_j(data.health);
        int foodDelta = data.foodLevel - entity.func_71024_bL().func_75116_a();
        float saturationDelta = data.saturation - entity.func_71024_bL().func_75115_e();
        entity.func_71024_bL().func_75122_a(foodDelta, saturationDelta);
        for (int i = 0; i < 25; ++i) {
            this.spawnParticle((Entity)entity, 1.0f, true, 4);
        }
    }

    public static class WarpData
    implements INBTSerializable<NBTTagCompound> {
        private BlockPos position;
        private float health;
        private int foodLevel;
        private float saturation;

        public WarpData() {
        }

        public WarpData(BlockPos position, float health, int foodLevel, float saturation) {
            this.position = position;
            this.health = health;
            this.foodLevel = foodLevel;
            this.saturation = saturation;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74772_a("pos", this.position.func_177986_g());
            compound.func_74776_a("health", this.health);
            compound.func_74768_a("food_level", this.foodLevel);
            compound.func_74776_a("saturation", this.saturation);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.position = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
            this.health = nbt.func_74760_g("health");
            this.foodLevel = nbt.func_74762_e("food_level");
            this.saturation = nbt.func_74760_g("saturation");
        }

        public String toString() {
            return "WarpData:" + this.position;
        }
    }
}

