/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.capabilities.effect.ProgressiveDataBundle;
import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.IProgressiveEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IgnatiusArmorEffect
extends BaseMetallurgyEffect
implements IProgressiveEffect {
    private static final DamageSource WATER_DAMAGE = new DamageSource("waterDamage"){

        @Nonnull
        public ITextComponent func_151519_b(@Nonnull EntityLivingBase entityLivingBaseIn) {
            return new TextComponentTranslation("message.metallurgy.water_damage_death", new Object[]{entityLivingBaseIn.func_145748_c_()});
        }
    }.func_76348_h();

    public IgnatiusArmorEffect() {
        super(ModMetals.IGNATIUS);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @Override
    public void onStep(World world, EntityPlayer entity, ItemStack effectStack, int maxSteps, int step) {
        int lavaImmunityTimespan;
        ProgressiveDataBundle bundle = this.getBundle(entity, this.metal, this.getCategory());
        if (!entity.func_180799_ab()) {
            bundle.resetProgress(entity);
        }
        if (step >= (lavaImmunityTimespan = this.getLevel((EntityLivingBase)entity) * (maxSteps / 10))) {
            bundle.resetProgress(entity);
            assert (this.metal.getArmorSet() != null);
            for (ItemArmorBase armorItem : this.metal.getArmorSet()) {
                entity.func_184811_cZ().func_185145_a((Item)armorItem, 200);
            }
        }
    }

    @SubscribeEvent
    public void lavaBath(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        int level = this.getLevel(entity);
        if (level == 0) {
            return;
        }
        DamageSource source = event.getSource();
        ProgressiveDataBundle bundle = null;
        if (entity instanceof EntityPlayer) {
            bundle = this.getBundle((EntityPlayer)entity, this.metal, this.getCategory());
        }
        if (!(source != DamageSource.field_76371_c || bundle != null && bundle.isEffectInProgress())) {
            if (entity instanceof EntityPlayer) {
                if (((EntityPlayer)entity).func_184811_cZ().func_185143_a(this.getArmorRepr(entity).func_77973_b(), 0.0f) > 0.0f) {
                    return;
                }
                assert (bundle != null);
                bundle.incrementStep((EntityPlayer)entity);
            }
            event.setCanceled(true);
        }
        if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76371_c && (bundle == null || bundle.isEffectInProgress())) {
            if (source == DamageSource.field_76371_c && entity.field_70173_aa % 25 - level * 5 == 0) {
                event.getEntityLiving().func_70691_i(event.getAmount() * ((float)level / 6.0f));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void dealWaterDamage(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!this.canBeApplied(entity)) {
            return;
        }
        if (entity.func_70026_G() && !entity.func_70644_a(MobEffects.field_76426_n)) {
            if (entity.field_70173_aa % 10 == 0) {
                entity.func_70097_a(WATER_DAMAGE, 1.0f);
                entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.0f, false);
            }
            this.spawnParticle((Entity)entity, 5.0f, true, 5);
        }
    }

    @SubscribeEvent
    public void drinkDamage(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!this.canBeApplied(entity)) {
            return;
        }
        EnumAction action = event.getItem().func_77973_b().func_77661_b(event.getItem());
        if (action == EnumAction.DRINK) {
            entity.func_70097_a(WATER_DAMAGE, 2.0f);
            entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.0f, false);
        }
    }
}

