/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.metallurgy_reforged.effect.armor;

import it.hurts.metallurgy_reforged.effect.BaseMetallurgyEffect;
import it.hurts.metallurgy_reforged.effect.EnumEffectCategory;
import it.hurts.metallurgy_reforged.effect.MetallurgyEffects;
import it.hurts.metallurgy_reforged.effect.all.TartariteEffect;
import it.hurts.metallurgy_reforged.item.armor.ItemArmorBase;
import it.hurts.metallurgy_reforged.material.ModMetals;
import it.hurts.metallurgy_reforged.util.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class HaderothArmorEffect
extends BaseMetallurgyEffect {
    public HaderothArmorEffect() {
        super(ModMetals.HADEROTH);
    }

    @Override
    @Nonnull
    public EnumEffectCategory getCategory() {
        return EnumEffectCategory.ARMOR;
    }

    @Override
    public Pair<String, String> getTooltip() {
        if (MetallurgyEffects.HADEROTH_EFFECT.isEnabled()) {
            MutablePair tooltip = MutablePair.of((Object)super.getTooltip().getLeft(), (Object)super.getTooltip().getRight());
            int firstBreak = ((String)tooltip.getRight()).indexOf("\n");
            String trimmed = ((String)tooltip.getRight()).substring(firstBreak + 1);
            tooltip.setValue((Object)trimmed);
            return tooltip;
        }
        return super.getTooltip();
    }

    @SubscribeEvent
    public void buffWearer(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!MetallurgyEffects.HADEROTH_EFFECT.isEnabled()) {
            return;
        }
        entity.func_184193_aE().forEach(stack -> {
            if (stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("reborn")) {
                return;
            }
            if (ItemUtils.isMadeOfMetal(this.metal, stack.func_77973_b(), new Class[0]) || TartariteEffect.getParagonMetal(stack) == this.metal) {
                ItemArmorBase haderothArmorPiece = (ItemArmorBase)stack.func_77973_b();
                switch (haderothArmorPiece.field_77881_a) {
                    case HEAD: {
                        if (!entity.func_70644_a(MobEffects.field_76438_s)) break;
                        entity.func_184589_d(MobEffects.field_76438_s);
                        break;
                    }
                    case CHEST: {
                        if (entity.field_70173_aa % 40 != 0) break;
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60, 0, false, false));
                        break;
                    }
                    case LEGS: {
                        if (!entity.func_70644_a(MobEffects.field_76421_d)) break;
                        entity.func_184589_d(MobEffects.field_76421_d);
                        break;
                    }
                    case FEET: {
                        if (!entity.func_70644_a(MobEffects.field_188424_y)) break;
                        entity.func_184589_d(MobEffects.field_188424_y);
                    }
                }
            }
        });
    }
}

